<?php
   $encodings=array("ANSI_X3.4-1968","ANSI_X3.4-1986","ASCII","CP367","IBM367","ISO-IR-6","ISO646-US","ISO_646.IRV:1991","US","US-ASCII","CSASCII","UTF-8","ISO-10646-UCS-2","UCS-2","CSUNICODE","UCS-2BE","UNICODE-1-1","UNICODEBIG","CSUNICODE11","UCS-2LE","UNICODELITTLE","ISO-10646-UCS-4","UCS-4","CSUCS4","UCS-4BE","UCS-4LE","UTF-16","UTF-16BE","UTF-16LE","UTF-32","UTF-32BE","UTF-32LE","UNICODE-1-1-UTF-7","UTF-7","CSUNICODE11UTF7","UCS-2-INTERNAL","UCS-2-SWAPPED","UCS-4-INTERNAL","UCS-4-SWAPPED","C99","JAVA","CP819","IBM819","ISO-8859-1","ISO-IR-100","ISO8859-1","ISO_8859-1","ISO_8859-1:1987","L1","LATIN1","CSISOLATIN1","ISO-8859-2","ISO-IR-101","ISO8859-2","ISO_8859-2","ISO_8859-2:1987","L2","LATIN2","CSISOLATIN2","ISO-8859-3","ISO-IR-109","ISO8859-3","ISO_8859-3","ISO_8859-3:1988","L3","LATIN3","CSISOLATIN3","ISO-8859-4","ISO-IR-110","ISO8859-4","ISO_8859-4","ISO_8859-4:1988","L4","LATIN4","CSISOLATIN4","CYRILLIC","ISO-8859-5","ISO-IR-144","ISO8859-5","ISO_8859-5","ISO_8859-5:1988","CSISOLATINCYRILLIC","ARABIC","ASMO-708","ECMA-114","ISO-8859-6","ISO-IR-127","ISO8859-6","ISO_8859-6","ISO_8859-6:1987","CSISOLATINARABIC","ECMA-118","ELOT_928","GREEK","GREEK8","ISO-8859-7","ISO-IR-126","ISO8859-7","ISO_8859-7","ISO_8859-7:1987","ISO_8859-7:2003","CSISOLATINGREEK","HEBREW","ISO-8859-8","ISO-IR-138","ISO8859-8","ISO_8859-8","ISO_8859-8:1988","CSISOLATINHEBREW","ISO-8859-9","ISO-IR-148","ISO8859-9","ISO_8859-9","ISO_8859-9:1989","L5","LATIN5","CSISOLATIN5","ISO-8859-10","ISO-IR-157","ISO8859-10","ISO_8859-10","ISO_8859-10:1992","L6","LATIN6","CSISOLATIN6","ISO-8859-11","ISO8859-11","ISO_8859-11","ISO-8859-13","ISO-IR-179","ISO8859-13","ISO_8859-13","L7","LATIN7","ISO-8859-14","ISO-CELTIC","ISO-IR-199","ISO8859-14","ISO_8859-14","ISO_8859-14:1998","L8","LATIN8","ISO-8859-15","ISO-IR-203","ISO8859-15","ISO_8859-15","ISO_8859-15:1998","LATIN-9","ISO-8859-16","ISO-IR-226","ISO8859-16","ISO_8859-16","ISO_8859-16:2001","L10","LATIN10","KOI8-R","CSKOI8R","KOI8-U","KOI8-RU","CP1250","MS-EE","WINDOWS-1250","CP1251","MS-CYRL","WINDOWS-1251","CP1252","MS-ANSI","WINDOWS-1252","CP1253","MS-GREEK","WINDOWS-1253","CP1254","MS-TURK","WINDOWS-1254","CP1255","MS-HEBR","WINDOWS-1255","CP1256","MS-ARAB","WINDOWS-1256","CP1257","WINBALTRIM","WINDOWS-1257","CP1258","WINDOWS-1258","850","CP850","IBM850","CSPC850MULTILINGUAL","862","CP862","IBM862","CSPC862LATINHEBREW","866","CP866","IBM866","CSIBM866","MAC","MACINTOSH","MACROMAN","CSMACINTOSH","MACCENTRALEUROPE","MACICELAND","MACCROATIAN","MACROMANIA","MACCYRILLIC","MACUKRAINE","MACGREEK","MACTURKISH","MACHEBREW","MACARABIC","MACTHAI","HP-ROMAN8","R8","ROMAN8","CSHPROMAN8","NEXTSTEP","ARMSCII-8","GEORGIAN-ACADEMY","GEORGIAN-PS","KOI8-T","CP154","CYRILLIC-ASIAN","PT154","PTCP154","CSPTCP154","KZ-1048","RK1048","STRK1048-2002","CSKZ1048","MULELAO-1","CP1133","IBM-CP1133","ISO-IR-166","TIS-620","TIS620","TIS620-0","TIS620.2529-1","TIS620.2533-0","TIS620.2533-1","CP874","WINDOWS-874","VISCII","VISCII1.1-1","CSVISCII","TCVN","TCVN-5712","TCVN5712-1","TCVN5712-1:1993","ISO-IR-14","ISO646-JP","JIS_C6220-1969-RO","JP","CSISO14JISC6220RO","JISX0201-1976","JIS_X0201","X0201","CSHALFWIDTHKATAKANA","ISO-IR-87","JIS0208","JIS_C6226-1983","JIS_X0208","JIS_X0208-1983","JIS_X0208-1990","X0208","CSISO87JISX0208","ISO-IR-159","JIS_X0212","JIS_X0212-1990","JIS_X0212.1990-0","X0212","CSISO159JISX02121990","CN","GB_1988-80","ISO-IR-57","ISO646-CN","CSISO57GB1988","CHINESE","GB_2312-80","ISO-IR-58","CSISO58GB231280","CN-GB-ISOIR165","ISO-IR-165","ISO-IR-149","KOREAN","KSC_5601","KS_C_5601-1987","KS_C_5601-1989","CSKSC56011987","EUC-JP","EUCJP","EXTENDED_UNIX_CODE_PACKED_FORMAT_FOR_JAPANESE","CSEUCPKDFMTJAPANESE","MS_KANJI","SHIFT-JIS","SHIFT_JIS","SJIS","CSSHIFTJIS","CP932","ISO-2022-JP","CSISO2022JP","ISO-2022-JP-1","ISO-2022-JP-2","CSISO2022JP2","CN-GB","EUC-CN","EUCCN","GB2312","CSGB2312","GBK","CP936","MS936","WINDOWS-936","GB18030","ISO-2022-CN","CSISO2022CN","ISO-2022-CN-EXT","HZ","HZ-GB-2312","EUC-TW","EUCTW","CSEUCTW","BIG-5","BIG-FIVE","BIG5","BIGFIVE","CN-BIG5","CSBIG5","CP950","BIG5-HKSCS:1999","BIG5-HKSCS:2001","BIG5-HKSCS","BIG5-HKSCS:2004","BIG5HKSCS","EUC-KR","EUCKR","CSEUCKR","CP949","UHC","CP1361","JOHAB","ISO-2022-KR","CSISO2022KR","CP856","CP922","CP943","CP1046","CP1124","CP1129","CP1161","IBM-1161","IBM1161","CSIBM1161","CP1162","IBM-1162","IBM1162","CSIBM1162","CP1163","IBM-1163","IBM1163","CSIBM1163","DEC-KANJI","DEC-HANYU","437","CP437","IBM437","CS","PC8CODEPAGE437","CP737","CP775","IBM775","CSPC775BALTIC","852","CP852","IBM852","CSPCP852","CP853","855","CP855","IBM855","CSIBM855","857","CP857","IBM857","CSIBM857","CP858","860","CP860","IBM860","CSIBM860","861","CP-IS","CP861","IBM861","CSIBM861","863","CP863","IBM863","CSIBM863","CP864","IBM864","CSIBM864","865","CP865","IBM865","CSIBM865","869","CP-GR","CP869","IBM869","CSIBM869","CP1125","EUC-JISX0213","SHIFT_JISX0213","ISO-2022-JP-3","BIG5-2003","ISO-IR-230","TDS565","ATARI","ATARIST","RISCOS-LATIN1");
   function newsomatic_items_panel()
   {
       $GLOBALS['wp_object_cache']->delete('newsomatic_rules_list', 'options');
        $all_rules = get_option('newsomatic_rules_list', array());
        if($all_rules === false || $all_rules == '')
        {
            $all_rules = array();
        }
        $rules_count = count($all_rules);
        $rules_per_page = get_option('newsomatic_posts_per_page', 10);
        $max_pages = ceil($rules_count/$rules_per_page);
        if($max_pages == 0)
        {
           $max_pages = 1;
        }
       
   $newsomatic_Main_Settings = get_option('newsomatic_Main_Settings', false);
   if (isset($newsomatic_Main_Settings['newsapi_active']) && trim($newsomatic_Main_Settings['newsapi_active']) == 'on')
   {
	   if(isset($newsomatic_Main_Settings['app_id']) && $newsomatic_Main_Settings['app_id'] != '')
	   {
	   }
	   else
	   {
	   ?>
	<h1><?php echo esc_html__("You must add a NewsAPI API Key before you can use this feature!", 'newsomatic-news-post-generator');?></h1>
	<?php
	       return;
	   }
   }
   else
   {
	   if(isset($newsomatic_Main_Settings['newsomatic_app_id']) && $newsomatic_Main_Settings['newsomatic_app_id'] != '')
	   {
	   }
	   else
	   {
	   ?>
	<h1><?php echo esc_html__("You must add a NewsomaticAPI API Key before you can use this feature!", 'newsomatic-news-post-generator');?></h1>
	<?php
	       return;
	   }
   }
   ?>
<div class="wp-header-end"></div>
<div class="wrap gs_popuptype_holder seo_pops">
   <div>
      <form id="myForm" method="post" action="<?php echo (newsomatic_isSecure() ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";?>">
         <?php
            wp_nonce_field('newsomatic_save_rules', '_newsomaticr_nonce');
            
            
            if (isset($_GET['settings-updated'])) {
            ?>
         <div>
            <p class="cr_saved_notif"><strong><?php echo esc_html__("Settings saved.", 'newsomatic-news-post-generator');?></strong></p>
         </div>
         <?php
            }
            ?>
         <div>
            <div class="hideMain">
               <hr/>
               <div class="table-responsive">
                  <table id="mainRules" class="responsive table cr_main_table">
                     <thead>
                        <tr>
                           <th class="cr_td_z">
                              <?php echo esc_html__("ID", 'newsomatic-news-post-generator');?>
                              <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                 <div class="bws_hidden_help_text cr_min_260px">
                                    <?php
                                       echo esc_html__("This is the ID of the rule. ", 'newsomatic-news-post-generator');
                                       ?>
                                 </div>
                              </div>
                           </th>
                           <th>
                              <?php echo esc_html__("Article Source", 'newsomatic-news-post-generator');?>
                              <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                 <div class="bws_hidden_help_text cr_min_260px">
                                    <?php
                                       echo esc_html__("Select the source site of the article. If you select 'Any' for this field, you must set at least one of the following advanced fields: 'Search Query String', 'Generated Post Country' or 'Generated Post Language', otherwise, importing will not work.", 'newsomatic-news-post-generator');
                                       ?>
                                 </div>
                              </div>
                           </th>
                           <th>
                              <?php echo esc_html__("Schedule", 'newsomatic-news-post-generator');?>
                              <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                 <div class="bws_hidden_help_text cr_min_260px">
                                    <?php
                                       $unlocker = get_option('newsomatic_minute_running_unlocked', false);
                                       if($unlocker == '1')
                                       {
                                           echo esc_html__("Select the interval in minutes after which you want this rule to run. Defined in minutes.", 'newsomatic-news-post-generator');
                                       }
                                       else
                                       {
                                           echo esc_html__("Select the interval in hours after which you want this rule to run. Defined in hours.", 'newsomatic-news-post-generator');
                                       }
                                       ?>
                                 </div>
                              </div>
                           </th>
                           <th>
                              <?php echo esc_html__("Max # Posts", 'newsomatic-news-post-generator');?>
                              <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                 <div class="bws_hidden_help_text cr_min_260px">
                                    <?php
                                       echo esc_html__("Select the maximum number of posts that this rule can create at once. 0-100 interval allowed.", 'newsomatic-news-post-generator');
                                       ?>
                                 </div>
                              </div>
                           </th>
                           <th>
                              <?php echo esc_html__("More Options", 'newsomatic-news-post-generator');?>
                              <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                 <div class="bws_hidden_help_text cr_min_260px">
                                    <?php
                                       echo esc_html__("Shows advanced settings for this rule.", 'newsomatic-news-post-generator');
                                       ?>
                                 </div>
                              </div>
                           </th>
                           <th class="cr_max_width_40">
                              <?php echo esc_html__("Del", 'newsomatic-news-post-generator');?>
                              <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                 <div class="bws_hidden_help_text cr_min_260px">
                                    <?php
                                       echo esc_html__("Do you want to delete this rule?", 'newsomatic-news-post-generator');
                                       ?>
                                 </div>
                              </div>
                           </th>
                           <th class="cr_max_55">
                              <?php echo esc_html__("Active", 'newsomatic-news-post-generator');?>
                              <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                 <div class="bws_hidden_help_text cr_min_260px">
                                    <?php
                                       echo esc_html__("Do you want to enable this rule? You can deactivate any rule (you don't have to delete them to deactivate them).", 'newsomatic-news-post-generator');
                                       ?>
                                 </div>
                              </div>
                              <br/>
                              <input type="checkbox" onchange="thisonChangeHandler(this)" id="exclusion">
                           </th>
                           <th class="cr_max_42">
                              <?php echo esc_html__("Info", 'newsomatic-news-post-generator');?>
                              <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                 <div class="bws_hidden_help_text cr_min_260px">
                                    <?php
                                       echo esc_html__("The number of items (posts, pages) this rule has generated so far.", 'newsomatic-news-post-generator');
                                       ?>
                                 </div>
                              </div>
                           </th>
                           <th class="cr_actions">
                              <?php echo esc_html__("Actions", 'newsomatic-news-post-generator');?>
                              <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                 <div class="bws_hidden_help_text cr_min_260px">
                                    <?php
                                       echo esc_html__("Do you want to run this rule now? Note that only one instance of a rule is allowed at once.", 'newsomatic-news-post-generator');
                                       ?>
                                 </div>
                              </div>
                           </th>
                        </tr>
                        
                     </thead>
                     <tbody>
                        <?php
                           echo newsomatic_expand_rules_manual();
                           if(isset($_GET['newsomatic_page']))
                            {
                                $current_page = $_GET['newsomatic_page'];
                            }
                            else
                            {
                                $current_page = '';
                            }
                            if($current_page == '' || (is_numeric($current_page) && $current_page == $max_pages))
                            {
                           ?>
                        
                        <tr>
                           <td class="cr_short_td"><input type="text" name="newsomatic_rules_list[rule_description][]" id="rule_description" class="cr_center" placeholder="Rule ID" value="" class="cr_width_full"/></td>
                           <td class="cr_sz">
                              <select id="date" name="newsomatic_rules_list[date][]" class="newsomatic_select2 cr_width_full">
                                 <option value="" disabled selected><?php echo esc_html__("Select an option", 'newsomatic-news-post-generator');?></option> 
                                 <option value="any"><?php echo esc_html__("Any", 'newsomatic-news-post-generator');?></option>                                 
                                 <option value="category-business"><?php echo esc_html__("Category - Business", 'newsomatic-news-post-generator');?></option>
                                 <option value="category-entertainment"><?php echo esc_html__("Category - Entertainment", 'newsomatic-news-post-generator');?></option>
                                 <option value="category-general"><?php echo esc_html__("Category - General", 'newsomatic-news-post-generator');?></option>
                                 <option value="category-health-and-medical"><?php echo esc_html__("Category - Health and Medical", 'newsomatic-news-post-generator');?></option>
                                 <option value="category-science-and-nature"><?php echo esc_html__("Category - Science and Nature", 'newsomatic-news-post-generator');?></option>
                                 <option value="category-sport"><?php echo esc_html__("Category - Sport", 'newsomatic-news-post-generator');?></option>
                                 <option value="category-technology"><?php echo esc_html__("Category - Technology", 'newsomatic-news-post-generator');?></option>
                                 <?php
                                    $cats = newsomatic_get_categories();
                                    if($cats !== false && isset($cats['category_list']) && is_array($cats['category_list']))
                                    {
                                        foreach($cats['category_list'] as $key => $cat)
                                        {
                                            echo'<option value="' . esc_attr($key) . '">' . esc_html($cat) . '</option>';
                                        }
                                    }
                                    ?> 
                              </select>
                           </td>
                           <td class="cr_comm_td"><input type="number" step="1" min="1" name="newsomatic_rules_list[schedule][]" max="8765812" class="cr_width_60" placeholder="Select the rule schedule interval" value="24"/></td>
                           <td class="cr_comm_td"><input type="number" step="1" min="0" max="100" name="newsomatic_rules_list[max][]" placeholder="Select the max # of generated posts" value="10" class="cr_width_60"/></td>
                           <td class="cr_width_70">
                              <input type="button" id="mybtnfzr" value="Settings">
                              <div id="mymodalfzr" class="codemodalfzr">
                                 <div class="codemodalfzr-content">
                                    <div class="codemodalfzr-header">
                                       <span id="newsomatic_close" class="codeclosefzr">&times;</span>
                                       <h2><span class="cr_color_white"><?php echo esc_html__("New Rule", 'newsomatic-news-post-generator');?></span> <?php echo esc_html__("Advanced Settings", 'newsomatic-news-post-generator');?></h2>
                                    </div>
                                    <div class="codemodalfzr-body">
                                       <div class="table-responsive">
                                          <table class="responsive table cr_main_table_nowr">
                                          <tr>
                                             <td colspan="2">
                                                <h3><?php echo esc_html__("NewsomaticAPI Advanced Settings:", 'newsomatic-news-post-generator');?></h3>
                                             </td>
                                          </tr>
                                             <tr>
                                                <td>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("Do you want to filter results based on a query string? Please note that only keywords are supported here (no phrase search). If you wish to use phrase search, please go to the 'Custom News to Posts' plugin menu and configure a rule there.", 'newsomatic-news-post-generator');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Search Query String:", 'newsomatic-news-post-generator');?></b>
                                                </td>
                                                <td>
                                                <input type="text" id="query_string" name="newsomatic_rules_list[query_string][]" value="" placeholder="<?php echo esc_html__("Please insert a query string", 'newsomatic-news-post-generator');?>" class="cr_width_full">
                                                </td>
                                             </tr>
                                          <tr>
                                                <td class="cr_min_width_200">
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("Select if you wish to filter the country of the generated posts. Will work only if you import post from news categories.", 'newsomatic-news-post-generator');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Generated Post Country:", 'newsomatic-news-post-generator');?></b>   
                                                </td>
                                                <td class="cr_min_width_200">
                                                <select id="post_country" name="newsomatic_rules_list[post_country][]" class="cr_width_full">
                                                <option value="all"><?php echo esc_html__("All", 'newsomatic-news-post-generator');?></option>
                                                <option value="ar"><?php echo esc_html__("Argentina", 'newsomatic-news-post-generator');?></option>
                                                <option value="au"><?php echo esc_html__("Australia", 'newsomatic-news-post-generator');?></option>
                                                <option value="br"><?php echo esc_html__("Brazil", 'newsomatic-news-post-generator');?></option>
                                                <option value="ca"><?php echo esc_html__("Canada", 'newsomatic-news-post-generator');?></option>
                                                <option value="cn"><?php echo esc_html__("China", 'newsomatic-news-post-generator');?></option>
                                                <option value="cz"><?php echo esc_html__("Czech Republic", 'newsomatic-news-post-generator');?></option>
                                                <option value="de"><?php echo esc_html__("Germany", 'newsomatic-news-post-generator');?></option>
                                                <option value="es"><?php echo esc_html__("Spain", 'newsomatic-news-post-generator');?></option>
                                                <option value="fr"><?php echo esc_html__("France", 'newsomatic-news-post-generator');?></option>
                                                <option value="gb"><?php echo esc_html__("Great Britain", 'newsomatic-news-post-generator');?></option>
                                                <option value="ie"><?php echo esc_html__("Republic of Ireland", 'newsomatic-news-post-generator');?></option>
                                                <option value="in"><?php echo esc_html__("India", 'newsomatic-news-post-generator');?></option>
                                                <option value="it"><?php echo esc_html__("Italy", 'newsomatic-news-post-generator');?></option>
                                                <option value="nl"><?php echo esc_html__("Netherlands", 'newsomatic-news-post-generator');?></option>
                                                <option value="no"><?php echo esc_html__("Norway", 'newsomatic-news-post-generator');?></option>
                                                <option value="pk"><?php echo esc_html__("Pakistan", 'newsomatic-news-post-generator');?></option>
                                                <option value="ru"><?php echo esc_html__("Russia", 'newsomatic-news-post-generator');?></option>
                                                <option value="sa"><?php echo esc_html__("Saudi Arabia", 'newsomatic-news-post-generator');?></option>
                                                <option value="se"><?php echo esc_html__("Sweden", 'newsomatic-news-post-generator');?></option>
                                                <option value="us" selected><?php echo esc_html__("United States", 'newsomatic-news-post-generator');?></option>
                                                <option value="za"><?php echo esc_html__("South Africa", 'newsomatic-news-post-generator');?></option>
                                                <option value="ae"><?php echo esc_html__("United Arab Emirates", 'newsomatic-news-post-generator');?></option>
                                                <option value="at"><?php echo esc_html__("Austria", 'newsomatic-news-post-generator');?></option>
                                                <option value="be"><?php echo esc_html__("Belgium", 'newsomatic-news-post-generator');?></option>
                                                <option value="bg"><?php echo esc_html__("Bulgaria", 'newsomatic-news-post-generator');?></option>
                                                <option value="ch"><?php echo esc_html__("Switzerland", 'newsomatic-news-post-generator');?></option>
                                                <option value="co"><?php echo esc_html__("Colombia", 'newsomatic-news-post-generator');?></option>
                                                <option value="cu"><?php echo esc_html__("Cuba", 'newsomatic-news-post-generator');?></option>
                                                <option value="eg"><?php echo esc_html__("Egypt", 'newsomatic-news-post-generator');?></option>
                                                <option value="gh"><?php echo esc_html__("Ghana", 'newsomatic-news-post-generator');?></option>
                                                <option value="gr"><?php echo esc_html__("Greece", 'newsomatic-news-post-generator');?></option>
                                                <option value="hk"><?php echo esc_html__("Hong Kong", 'newsomatic-news-post-generator');?></option>
                                                <option value="hu"><?php echo esc_html__("Hungary", 'newsomatic-news-post-generator');?></option>
                                                <option value="id"><?php echo esc_html__("Indonesia", 'newsomatic-news-post-generator');?></option>
                                                <option value="is"><?php echo esc_html__("Israel", 'newsomatic-news-post-generator');?></option>
                                                <option value="jp"><?php echo esc_html__("Japan", 'newsomatic-news-post-generator');?></option>
                                                <option value="kr"><?php echo esc_html__("South Korea", 'newsomatic-news-post-generator');?></option>
                                                <option value="lt"><?php echo esc_html__("Lithuania", 'newsomatic-news-post-generator');?></option>
                                                <option value="lv"><?php echo esc_html__("Latvia", 'newsomatic-news-post-generator');?></option>
                                                <option value="ma"><?php echo esc_html__("Morocco", 'newsomatic-news-post-generator');?></option>
                                                <option value="mx"><?php echo esc_html__("Mexico", 'newsomatic-news-post-generator');?></option>
                                                <option value="my"><?php echo esc_html__("Malaysia", 'newsomatic-news-post-generator');?></option>
                                                <option value="ng"><?php echo esc_html__("Nigeria", 'newsomatic-news-post-generator');?></option>
                                                <option value="nz"><?php echo esc_html__("New Zealand", 'newsomatic-news-post-generator');?></option>
                                                <option value="pe"><?php echo esc_html__("Peru", 'newsomatic-news-post-generator');?></option>
                                                <option value="ph"><?php echo esc_html__("Philippines", 'newsomatic-news-post-generator');?></option>
                                                <option value="pl"><?php echo esc_html__("Poland", 'newsomatic-news-post-generator');?></option>
                                                <option value="pt"><?php echo esc_html__("Portugal", 'newsomatic-news-post-generator');?></option>
                                                <option value="ro"><?php echo esc_html__("Romania", 'newsomatic-news-post-generator');?></option>
                                                <option value="rs"><?php echo esc_html__("Serbia", 'newsomatic-news-post-generator');?></option>
                                                <option value="sg"><?php echo esc_html__("Singapore", 'newsomatic-news-post-generator');?></option>
                                                <option value="si"><?php echo esc_html__("Slovenia", 'newsomatic-news-post-generator');?></option>
                                                <option value="sk"><?php echo esc_html__("Slovakia", 'newsomatic-news-post-generator');?></option>
                                                <option value="th"><?php echo esc_html__("Thailand", 'newsomatic-news-post-generator');?></option>
                                                <option value="tr"><?php echo esc_html__("Turkey", 'newsomatic-news-post-generator');?></option>
                                                <option value="tt"><?php echo esc_html__("Trinidad and Tobago", 'newsomatic-news-post-generator');?></option>
                                                <option value="tw"><?php echo esc_html__("Taiwan", 'newsomatic-news-post-generator');?></option>
                                                <option value="ua"><?php echo esc_html__("Ukraine", 'newsomatic-news-post-generator');?></option>
                                                <option value="ve"><?php echo esc_html__("Venezuela", 'newsomatic-news-post-generator');?></option>
                                                <option value="vn"><?php echo esc_html__("Vietnam", 'newsomatic-news-post-generator');?></option>
                                                </select>     
                                                </div>
                                                </td>
                                             </tr>
                                             <tr>
                                                <td class="cr_min_width_200">
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("Select if you wish to exclude the list of countries from below. You can add a maximum of 5 countries to exclude. To disable country exclusion, leave this field blank. This will work only if you import post from Any source (applicable only for NewsomaticAPI).", 'newsomatic-news-post-generator');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Exclude Countries:", 'newsomatic-news-post-generator');?></b>   
                                                </td>
                                                <td class="cr_min_width_200">
                                                <select id="exclude_country" class="max_5val" name="newsomatic_rules_list[exclude_country][]" multiple <?php if (isset($newsomatic_Main_Settings['newsapi_active']) && trim($newsomatic_Main_Settings['newsapi_active']) == 'on'){echo ' disabled';}?> class="cr_width_full">
                                                <option value="no_exclude" selected><?php echo esc_html__("Do Not Exclude Countries", 'newsomatic-news-post-generator');?></option>
                                                <option value="ar"><?php echo esc_html__("Argentina", 'newsomatic-news-post-generator');?></option>
                                                <option value="au"><?php echo esc_html__("Australia", 'newsomatic-news-post-generator');?></option>
                                                <option value="br"><?php echo esc_html__("Brazil", 'newsomatic-news-post-generator');?></option>
                                                <option value="ca"><?php echo esc_html__("Canada", 'newsomatic-news-post-generator');?></option>
                                                <option value="cn"><?php echo esc_html__("China", 'newsomatic-news-post-generator');?></option>
                                                <option value="cz"><?php echo esc_html__("Czech Republic", 'newsomatic-news-post-generator');?></option>
                                                <option value="de"><?php echo esc_html__("Germany", 'newsomatic-news-post-generator');?></option>
                                                <option value="es"><?php echo esc_html__("Spain", 'newsomatic-news-post-generator');?></option>
                                                <option value="fr"><?php echo esc_html__("France", 'newsomatic-news-post-generator');?></option>
                                                <option value="gb"><?php echo esc_html__("Great Britain", 'newsomatic-news-post-generator');?></option>
                                                <option value="ie"><?php echo esc_html__("Republic of Ireland", 'newsomatic-news-post-generator');?></option>
                                                <option value="in"><?php echo esc_html__("India", 'newsomatic-news-post-generator');?></option>
                                                <option value="it"><?php echo esc_html__("Italy", 'newsomatic-news-post-generator');?></option>
                                                <option value="nl"><?php echo esc_html__("Netherlands", 'newsomatic-news-post-generator');?></option>
                                                <option value="no"><?php echo esc_html__("Norway", 'newsomatic-news-post-generator');?></option>
                                                <option value="pk"><?php echo esc_html__("Pakistan", 'newsomatic-news-post-generator');?></option>
                                                <option value="ru"><?php echo esc_html__("Russia", 'newsomatic-news-post-generator');?></option>
                                                <option value="sa"><?php echo esc_html__("Saudi Arabia", 'newsomatic-news-post-generator');?></option>
                                                <option value="se"><?php echo esc_html__("Sweden", 'newsomatic-news-post-generator');?></option>
                                                <option value="us"><?php echo esc_html__("United States", 'newsomatic-news-post-generator');?></option>
                                                <option value="za"><?php echo esc_html__("South Africa", 'newsomatic-news-post-generator');?></option>
                                                <option value="ae"><?php echo esc_html__("United Arab Emirates", 'newsomatic-news-post-generator');?></option>
                                                <option value="at"><?php echo esc_html__("Austria", 'newsomatic-news-post-generator');?></option>
                                                <option value="be"><?php echo esc_html__("Belgium", 'newsomatic-news-post-generator');?></option>
                                                <option value="bg"><?php echo esc_html__("Bulgaria", 'newsomatic-news-post-generator');?></option>
                                                <option value="ch"><?php echo esc_html__("Switzerland", 'newsomatic-news-post-generator');?></option>
                                                <option value="co"><?php echo esc_html__("Colombia", 'newsomatic-news-post-generator');?></option>
                                                <option value="cu"><?php echo esc_html__("Cuba", 'newsomatic-news-post-generator');?></option>
                                                <option value="eg"><?php echo esc_html__("Egypt", 'newsomatic-news-post-generator');?></option>
                                                <option value="gh"><?php echo esc_html__("Ghana", 'newsomatic-news-post-generator');?></option>
                                                <option value="gr"><?php echo esc_html__("Greece", 'newsomatic-news-post-generator');?></option>
                                                <option value="hk"><?php echo esc_html__("Hong Kong", 'newsomatic-news-post-generator');?></option>
                                                <option value="hu"><?php echo esc_html__("Hungary", 'newsomatic-news-post-generator');?></option>
                                                <option value="id"><?php echo esc_html__("Indonesia", 'newsomatic-news-post-generator');?></option>
                                                <option value="is"><?php echo esc_html__("Israel", 'newsomatic-news-post-generator');?></option>
                                                <option value="jp"><?php echo esc_html__("Japan", 'newsomatic-news-post-generator');?></option>
                                                <option value="kr"><?php echo esc_html__("South Korea", 'newsomatic-news-post-generator');?></option>
                                                <option value="lt"><?php echo esc_html__("Lithuania", 'newsomatic-news-post-generator');?></option>
                                                <option value="lv"><?php echo esc_html__("Latvia", 'newsomatic-news-post-generator');?></option>
                                                <option value="ma"><?php echo esc_html__("Morocco", 'newsomatic-news-post-generator');?></option>
                                                <option value="mx"><?php echo esc_html__("Mexico", 'newsomatic-news-post-generator');?></option>
                                                <option value="my"><?php echo esc_html__("Malaysia", 'newsomatic-news-post-generator');?></option>
                                                <option value="ng"><?php echo esc_html__("Nigeria", 'newsomatic-news-post-generator');?></option>
                                                <option value="nz"><?php echo esc_html__("New Zealand", 'newsomatic-news-post-generator');?></option>
                                                <option value="pe"><?php echo esc_html__("Peru", 'newsomatic-news-post-generator');?></option>
                                                <option value="ph"><?php echo esc_html__("Philippines", 'newsomatic-news-post-generator');?></option>
                                                <option value="pl"><?php echo esc_html__("Poland", 'newsomatic-news-post-generator');?></option>
                                                <option value="pt"><?php echo esc_html__("Portugal", 'newsomatic-news-post-generator');?></option>
                                                <option value="ro"><?php echo esc_html__("Romania", 'newsomatic-news-post-generator');?></option>
                                                <option value="rs"><?php echo esc_html__("Serbia", 'newsomatic-news-post-generator');?></option>
                                                <option value="sg"><?php echo esc_html__("Singapore", 'newsomatic-news-post-generator');?></option>
                                                <option value="si"><?php echo esc_html__("Slovenia", 'newsomatic-news-post-generator');?></option>
                                                <option value="sk"><?php echo esc_html__("Slovakia", 'newsomatic-news-post-generator');?></option>
                                                <option value="th"><?php echo esc_html__("Thailand", 'newsomatic-news-post-generator');?></option>
                                                <option value="tr"><?php echo esc_html__("Turkey", 'newsomatic-news-post-generator');?></option>
                                                <option value="tt"><?php echo esc_html__("Trinidad and Tobago", 'newsomatic-news-post-generator');?></option>
                                                <option value="tw"><?php echo esc_html__("Taiwan", 'newsomatic-news-post-generator');?></option>
                                                <option value="ua"><?php echo esc_html__("Ukraine", 'newsomatic-news-post-generator');?></option>
                                                <option value="ve"><?php echo esc_html__("Venezuela", 'newsomatic-news-post-generator');?></option>
                                                <option value="vn"><?php echo esc_html__("Vietnam", 'newsomatic-news-post-generator');?></option>
                                                </select>     
                                                </div>
                                                </td>
                                             </tr>
                                             <tr>
                                                <td class="cr_min_width_200">
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("Select if you wish to filter the language of the generated posts. Will work only if you import post from Any or from categories (applicable only for NewsomaticAPI)", 'newsomatic-news-post-generator');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Generated Post Language:", 'newsomatic-news-post-generator');?></b>   
                                                </td>
                                                <td class="cr_min_width_200">
                                                <select id="post_language" name="newsomatic_rules_list[post_language][]" <?php if (isset($newsomatic_Main_Settings['newsapi_active']) && trim($newsomatic_Main_Settings['newsapi_active']) == 'on'){echo ' disabled';}?> class="cr_width_full">
                                                <option value="all" selected><?php echo esc_html__("All", 'newsomatic-news-post-generator');?></option>
                                                <option value="en"><?php echo esc_html__("English", 'newsomatic-news-post-generator');?></option>
                                                <option value="cz"><?php echo esc_html__("Czech", 'newsomatic-news-post-generator');?></option>
                                                <option value="ar"><?php echo esc_html__("Arabic", 'newsomatic-news-post-generator');?></option>
                                                <option value="bg"><?php echo esc_html__("Bulgarian", 'newsomatic-news-post-generator');?></option>
                                                <option value="zh"><?php echo esc_html__("Chinese", 'newsomatic-news-post-generator');?></option>
                                                <option value="de"><?php echo esc_html__("German", 'newsomatic-news-post-generator');?></option>
                                                <option value="es"><?php echo esc_html__("Spanish", 'newsomatic-news-post-generator');?></option>
                                                <option value="fr"><?php echo esc_html__("French", 'newsomatic-news-post-generator');?></option>
                                                <option value="gr"><?php echo esc_html__("Greek", 'newsomatic-news-post-generator');?></option>
                                                <option value="he"><?php echo esc_html__("Hebrew", 'newsomatic-news-post-generator');?></option>
                                                <option value="hu"><?php echo esc_html__("Hungarian", 'newsomatic-news-post-generator');?></option>
                                                <option value="hd"><?php echo esc_html__("Hindi", 'newsomatic-news-post-generator');?></option>
                                                <option value="id"><?php echo esc_html__("Indonesian", 'newsomatic-news-post-generator');?></option>
                                                <option value="kr"><?php echo esc_html__("Korean", 'newsomatic-news-post-generator');?></option>
                                                <option value="it"><?php echo esc_html__("Italian", 'newsomatic-news-post-generator');?></option>
                                                <option value="lv"><?php echo esc_html__("Latvian", 'newsomatic-news-post-generator');?></option>
                                                <option value="lt"><?php echo esc_html__("Lithuanian", 'newsomatic-news-post-generator');?></option>
                                                <option value="pl"><?php echo esc_html__("Polish", 'newsomatic-news-post-generator');?></option>
                                                <option value="ro"><?php echo esc_html__("Romanian", 'newsomatic-news-post-generator');?></option>
                                                <option value="cr"><?php echo esc_html__("Croatian", 'newsomatic-news-post-generator');?></option>
                                                <option value="rs"><?php echo esc_html__("Bosnian", 'newsomatic-news-post-generator');?></option>
                                                <option value="sx"><?php echo esc_html__("Serbian", 'newsomatic-news-post-generator');?></option>
                                                <option value="si"><?php echo esc_html__("Slovenian", 'newsomatic-news-post-generator');?></option>
                                                <option value="sk"><?php echo esc_html__("Slovak", 'newsomatic-news-post-generator');?></option>
                                                <option value="nl"><?php echo esc_html__("Dutch", 'newsomatic-news-post-generator');?></option>
                                                <option value="no"><?php echo esc_html__("Norwegian", 'newsomatic-news-post-generator');?></option>
                                                <option value="pt"><?php echo esc_html__("Portuguese", 'newsomatic-news-post-generator');?></option>
                                                <option value="ru"><?php echo esc_html__("Russian", 'newsomatic-news-post-generator');?></option>
                                                <option value="se"><?php echo esc_html__("Swedish", 'newsomatic-news-post-generator');?></option>
                                                <option value="ud"><?php echo esc_html__("Urdu", 'newsomatic-news-post-generator');?></option>
                                                <option value="vn"><?php echo esc_html__("Vietnamese", 'newsomatic-news-post-generator');?></option>
                                                </select>     
                                                </div>
                                                </td>
                                             </tr>
                                             <tr>
                                                <td>
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("A comma-separated string of domains (eg bbc.co.uk,techcrunch.com,engadget.com) to restrict the search to.", 'newsomatic-news-post-generator');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Include Only These Domains in Results:", 'newsomatic-news-post-generator');?></b>
                                                </td>
                                                <td>
                                                <input type="text" id="only_domains" name="newsomatic_rules_list[only_domains][]" <?php if (isset($newsomatic_Main_Settings['newsapi_active']) && trim($newsomatic_Main_Settings['newsapi_active']) == 'on'){echo ' disabled';}?> value="" placeholder="Comma separated domain list" class="cr_width_full">
                                                </div>
                                                </td>
                                             </tr>
                                             <tr>
                                                <td>
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("A comma-separated string of domains (eg bbc.co.uk,techcrunch.com,engadget.com) to remove from the results.", 'newsomatic-news-post-generator');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Remove Domains from Results:", 'newsomatic-news-post-generator');?></b>
                                                </td>
                                                <td>
                                                <input type="text" id="remove_domains" name="newsomatic_rules_list[remove_domains][]" <?php if (isset($newsomatic_Main_Settings['newsapi_active']) && trim($newsomatic_Main_Settings['newsapi_active']) == 'on'){echo ' disabled';}?> value="" placeholder="Comma separated domain list" class="cr_width_full">
                                                </div>
                                                </td>
                                             </tr>
                                             <tr>
                                                <td>
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("Do you want to remember last posted item and continue search from it the next time the importing rule runs?", 'newsomatic-news-post-generator');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Cache Items For Continuous Posting (disable to get latest posts only):", 'newsomatic-news-post-generator');?></b>
                                                </td>
                                                <td>
                                                <input type="checkbox" id="continue_search" name="newsomatic_rules_list[continue_search][]">
                                                </div>
                                                </td>
                                             </tr>
                                             <tr>
                                             <td colspan="2">
                                                <h3><?php echo esc_html__("Generated Post Customizations:", 'newsomatic-news-post-generator');?></h3>
                                             </td>
                                          </tr>
                                             <tr>
                                                <td class="cr_min_width_200">
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("Set the title of the generated posts for user rules. You can use the following shortcodes: %%random_sentence%%, %%random_sentence2%%, %%random_image[keyword]%%, %%random_image_url[keyword]%%, %%item_date%%, %%item_media%%, %%author%%, %%item_title%%, %%item_description%%, %%item_content%%, %%item_original_content%%, %%item_cat%%, %%item_tags%%, %%keyword_search%%, %%item_source%%, %%item_source_id%%", 'newsomatic-news-post-generator');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Generated Post Title:", 'newsomatic-news-post-generator');?></b>&nbsp;<b><a href="https://coderevolution.ro/knowledge-base/faq/post-template-reference-advanced-usage/" target="_blank">&#9432;</a></b>
                                                </td>
                                                <td>
                                                <input type="text" name="newsomatic_rules_list[post_title][]" value="%%item_title%%" placeholder="Please insert your desired post title. Example: %%item_title%%" class="cr_width_full">
                                                </div>
                                                </td>
                                             </tr>
                                             <tr>
                                                <td class="cr_min_width_200">
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("Set the content of the generated posts for user rules. You can use the following shortcodes: %%item_read_more_button%%, %%item_media%%, %%custom_html%%, %%custom_html2%%, %%random_sentence%%, %%random_sentence2%%, %%random_image[keyword]%%, %%random_image_url[keyword]%%, %%item_date%%, %%item_media%%, %%item_title%%, %%item_description%%, %%item_content%%, %%item_content_plain_text%%, %%royalty_free_image_attribution%%, %%item_url%%, %%item_cat%%, %%item_tags%%, %%keyword_search%%, %%item_show_image%%, %%item_image_URL%%, %%author%%, %%author_link%%, %%item_source%%, %%item_source_id%%", 'newsomatic-news-post-generator');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Generated Post Content:", 'newsomatic-news-post-generator');?></b>&nbsp;<b><a href="https://coderevolution.ro/knowledge-base/faq/post-template-reference-advanced-usage/" target="_blank">&#9432;</a></b>
                                                </td>
                                                <td>
                                                <textarea rows="2" cols="70" name="newsomatic_rules_list[post_content][]" placeholder="Please insert your desired post content. Example: %%item_content%%<br/>%%item_read_more_button%%" class="cr_width_full">%%item_content%%<br/>%%item_read_more_button%%</textarea>
                                                </div>
                                                </td>
                                             </tr>
                                             
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo esc_html__("Select the status that you want for the automatically generated posts to have.", 'newsomatic-news-post-generator');
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Generated Post Status:", 'newsomatic-news-post-generator');?></b>   
                                             </td>
                                             <td>
                                             <select id="submit_status" name="newsomatic_rules_list[submit_status][]" class="cr_width_70">
                                                <option value="pending"><?php echo esc_html__("Pending -> Moderate", 'newsomatic-news-post-generator');?></option>
                                                <option value="draft"><?php echo esc_html__("Draft -> Moderate", 'newsomatic-news-post-generator');?></option>
                                                <option value="publish" selected><?php echo esc_html__("Published", 'newsomatic-news-post-generator');?></option>
                                                <option value="private"><?php echo esc_html__("Private", 'newsomatic-news-post-generator');?></option>
                                                <option value="trash"><?php echo esc_html__("Trash", 'newsomatic-news-post-generator');?></option>
                                             </select>    
                                             </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo esc_html__("Select the type (post/page) for your automatically generated item.", 'newsomatic-news-post-generator');
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Generated Post Type:", 'newsomatic-news-post-generator');?></b>   
                                             </td>
                                             <td><select id="default_type" name="newsomatic_rules_list[default_type][]" class="cr_width_auto">
                                             <?php
                                                $is_first = true;
                                                foreach ( get_post_types( '', 'names' ) as $post_type ) {
                                                   echo '<option value="' . esc_attr($post_type) . '"';
                                                   if($is_first === true)
                                                   {
                                                      echo ' selected';
                                                      $is_first = false;
                                                   }
                                                   echo '>' . esc_html($post_type) . '</option>';
                                                }
                                                ?>
                                             </select>  
                                             </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo esc_html__("Select the author that you want to assign for the automatically generated posts.	", 'newsomatic-news-post-generator');
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Generated Post Author:", 'newsomatic-news-post-generator');?></b>   
                                             </td>
                                             <td><select id="post_author" name="newsomatic_rules_list[post_author][]" class="cr_width_auto cr_max_width_150">
                                                   <option value="rand"><?php echo esc_html__("Random user", 'newsomatic-news-post-generator');?></option>
                                                   <option value="feed-news"><?php echo esc_html__("Import source author", 'newsomatic-news-post-generator');?></option>
                              <?php
                                 $blogusers = get_users( [ 'role__in' => [ 'contributor', 'author', 'editor', 'administrator' ] ] );
                                 foreach ($blogusers as $user) {
                                     echo '<option value="' . esc_html($user->ID) . '"';
                                     echo '>' . esc_html($user->display_name) . '</option>';
                                 }
                                 ?>
                              </select>  
                                             </div>
                                             </td>
                                          </tr>
                                             <tr>
                                                <td>
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("Do you want to disable post excerpt generation?", 'newsomatic-news-post-generator');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Disable Post Excerpt Generation:", 'newsomatic-news-post-generator');?></b>
                                                </td>
                                                <td>
                                                <input type="checkbox" id="disable_excerpt" name="newsomatic_rules_list[disable_excerpt][]" checked>   
                                                </div>
                                                </td>
                                             </tr>
                                             <tr>
                                                <td>
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("Do you want to to set the post published date as the date grabbed from the article? If you disable this feature, the date when the rule is run will be used.", 'newsomatic-news-post-generator');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Get Post Publish Date From Item:", 'newsomatic-news-post-generator');?></b>
                                                </td>
                                                <td>
                                                <input type="checkbox" id="import_date" name="newsomatic_rules_list[import_date][]">
                                                </div>
                                                </td>
                                             </tr>
                                             <tr>
                                                <td class="cr_min_width_200">
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("If your template supports 'Post Formats', than you can select one here. If not, leave this at it's default value.", 'newsomatic-news-post-generator');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Generated Post Format:", 'newsomatic-news-post-generator');?></b>   
                                                </td>
                                                <td class="cr_min_width_200">
                                                <select id="post_format" name="newsomatic_rules_list[post_format][]" class="cr_width_full">
                                                <option value="post-format-standard"  selected><?php echo esc_html__("Standard", 'newsomatic-news-post-generator');?></option>
                                                <option value="post-format-aside"><?php echo esc_html__("Aside", 'newsomatic-news-post-generator');?></option>
                                                <option value="post-format-gallery"><?php echo esc_html__("Gallery", 'newsomatic-news-post-generator');?></option>
                                                <option value="post-format-link"><?php echo esc_html__("Link", 'newsomatic-news-post-generator');?></option>
                                                <option value="post-format-image"><?php echo esc_html__("Image", 'newsomatic-news-post-generator');?></option>
                                                <option value="post-format-quote"><?php echo esc_html__("Quote", 'newsomatic-news-post-generator');?></option>
                                                <option value="post-format-status"><?php echo esc_html__("Status", 'newsomatic-news-post-generator');?></option>
                                                <option value="post-format-video"><?php echo esc_html__("Video", 'newsomatic-news-post-generator');?></option>
                                                <option value="post-format-audio"><?php echo esc_html__("Audio", 'newsomatic-news-post-generator');?></option>
                                                <option value="post-format-chat"><?php echo esc_html__("Chat", 'newsomatic-news-post-generator');?></option>
                                                </select>     
                                                </div>
                                                </td>
                                             </tr>
                                             <tr>
                                                <td class="cr_min_width_200">
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("Select the post category that you want for the automatically generated posts to have. To select more categories, hold down the CTRL key.", 'newsomatic-news-post-generator');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Additional Post Category:", 'newsomatic-news-post-generator');?></b>
                                                </td>
                                                <td>
                                                <select multiple id="default_category" name="newsomatic_rules_list[default_category][]" class="cr_width_full">
                                                <option value="newsomatic_no_category_12345678" selected><?php echo esc_html__("Do Not Add a Category", 'newsomatic-news-post-generator');?></option>
                                                <?php
                                                   $cat_args   = array(
                                                       'orderby' => 'name',
                                                       'hide_empty' => 0,
                                                       'order' => 'ASC'
                                                   );
                                                   $categories = get_categories($cat_args);
                                                   foreach ($categories as $category) {
                                                   ?>
                                                <option value="<?php
                                                   echo esc_html($category->term_id);
                                                   ?>"><?php
                                                   echo esc_html(sanitize_text_field($category->name)) . ' - ID ' . esc_html($category->term_id);
                                                   ?></option>
                                                <?php
                                                   }
                                                   ?>
                                                </select>     
                                                </div>
                                                </td>
                                             </tr>
                                             <tr>
                                                <td>
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("Do you want to automatically add post categories from the News items?", 'newsomatic-news-post-generator');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Auto Add Categories:", 'newsomatic-news-post-generator');?></b>
                                                </td>
                                                <td>
                                                <select id="auto_categories" name="newsomatic_rules_list[auto_categories][]" class="cr_width_full">
                                                <option value="disabled" selected><?php echo esc_html__("Disabled", 'newsomatic-news-post-generator');?></option>
                                                <option value="title"><?php echo esc_html__("Title", 'newsomatic-news-post-generator');?></option>                  
                                                </div>
                                                </td>
                                             </tr>
                                             <tr>
                                                <td class="cr_min_width_200">
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("This option will search the content for the keyword and if exists, it will assign the set category to the post. Example: \"sugar,diet|category_slug1,category_slug2\" without quotes - the plugin will check the content and if it contains the keyword \"sugar\" and the keyword \"diet\" it will assign the post to the category with slug=category_slug1 and also the category with slug=category_slug2.", 'newsomatic-news-post-generator');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Keyword to Category (keyword|categorySlug - one per line):", 'newsomatic-news-post-generator');?></b>
                                                </td>
                                                <td>
                                                <textarea rows="2" cols="70" name="newsomatic_rules_list[keyword_category][]" placeholder="sugar,diet|category_slug1,category_slug2" class="cr_width_full"></textarea>
                                                </div>
                                                </td>
                                             </tr>
                                             <tr>
                                                <td class="cr_min_width_200">
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("This option will search the content for the keyword and if exists, it will assign the set tags to the post. Example: \"sugar,diet|tag_slug1,tag_slug2\" without quotes - the plugin will check the content and if it contains the keyword \"sugar\" and the keyword \"diet\" it will assign the post to the tag with slug=tag_slug1 and also the tag with slug=tag_slug2.", 'newsomatic-news-post-generator');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Keyword to Tags (keyword|tags - one per line):", 'newsomatic-news-post-generator');?></b>
                                                </td>
                                                <td>
                                                <textarea rows="2" cols="70" name="newsomatic_rules_list[keyword_tag][]" placeholder="sugar,diet|tag_slug1,tag_slug2" class="cr_width_full"></textarea>
                                                </div>
                                                </td>
                                             </tr>
                                             <tr><td>
                                             <div>
                                             <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                             <div class="bws_hidden_help_text cr_min_260px">
                                             <?php
                                                echo esc_html__("This feature will try to remove the WordPress's default post category. This may fail in case no additional categories are added, because WordPress requires at least one post category for every post.", 'newsomatic-news-post-generator');
                                                ?>
                                             </div>
                                             </div>
                                             <b><?php echo esc_html__("Remove WP Default Post Category:", 'newsomatic-news-post-generator');?></b>
                                             </td><td>
                                             <input type="checkbox" id="remove_default" name="newsomatic_rules_list[remove_default][]" checked>
                                             </div>
                                             </td></tr><tr><td>
                                             <div>
                                             <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                             <div class="bws_hidden_help_text cr_min_260px">
                                             <?php
                                                echo esc_html__("Do you want to automatically add post tags from the News items?", 'newsomatic-news-post-generator');
                                                ?>
                                             </div>
                                             </div>
                                             <b><?php echo esc_html__("Auto Add Tags:", 'newsomatic-news-post-generator');?></b>
                                             </td><td>
                                             <select id="auto_tags" name="newsomatic_rules_list[auto_tags][]" class="cr_width_full">
                                             <option value="disabled" selected><?php echo esc_html__("Disabled", 'newsomatic-news-post-generator');?></option>
                                             <option value="title"><?php echo esc_html__("Title", 'newsomatic-news-post-generator');?></option></select>                   
                                             </div>
                                             </td></tr>
                                             <tr>
                                                <td>
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("Select the post tags that you want for the automatically generated posts to have.", 'newsomatic-news-post-generator');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Additional Post Tags:", 'newsomatic-news-post-generator');?></b>
                                                </td>
                                                <td>
                                                <input type="text" name="newsomatic_rules_list[default_tags][]" value="" placeholder="Please insert your additional post tags here" class="cr_width_full">
                                                </div>
                                                </td>
                                             </tr>
                                             <tr>
                                                <td>
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("Do you want to enable comments for the generated posts?", 'newsomatic-news-post-generator');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Enable Comments For Posts:", 'newsomatic-news-post-generator');?></b>
                                                </td>
                                                <td>
                                                <input type="checkbox" id="enable_comments" name="newsomatic_rules_list[enable_comments][]" checked>
                                                </div>
                                                </td>
                                             </tr>
                                             <tr>
                                                <td>
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("Do you want to enable pingbacks/trackbacks for the generated posts?", 'newsomatic-news-post-generator');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Enable Pingback/Trackback:", 'newsomatic-news-post-generator');?></b>
                                                </td>
                                                <td>
                                                <input type="checkbox" id="enable_pingback" name="newsomatic_rules_list[enable_pingback][]" checked>
                                                </div>
                                                </td>
                                             </tr>
                                             <tr>
                                                <td class="cr_min_width_200">
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("Set the custom fields that will be set for generated posts. The syntax for this field is the following: custom_field_name1 => custom_field_value1, custom_field_name2 => custom_field_value2, ... . In custom_field_valueX, you can use shortcodes, same like in post content. You can also assign the data to array custom fields, using this format: array_field[index_name1] => custom_field_value1, array_field[index_name2] => custom_field_value2. Example (without quotes): 'title_custom_field => %%item_title%%'. You can use the following shortcodes: %%item_read_more_button%%, %%item_media%%, %%custom_html%%, %%custom_html2%%, %%random_sentence%%, %%random_sentence2%%, %%random_image[keyword]%%, %%random_image_url[keyword]%%, %%item_title%%, %%item_description%%, %%item_content%%, %%item_content_plain_text%%, %%royalty_free_image_attribution%%, %%item_url%%, %%item_cat%%, %%item_tags%%, %%keyword_search%%, %%item_show_image%%, %%item_image_URL%%, %%author%%, %%author_link%%, %%item_source%%, %%item_source_id%%", 'newsomatic-news-post-generator');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Post Custom Fields:", 'newsomatic-news-post-generator');?></b>&nbsp;<b><a href="https://coderevolution.ro/knowledge-base/faq/post-template-reference-advanced-usage/" target="_blank">&#9432;</a></b>
                                                </td>
                                                <td>
                                                <textarea rows="1" cols="70" name="newsomatic_rules_list[custom_fields][]" placeholder="Please insert your desired custom fields. Example: title_custom_field => %%item_title%%" class="cr_width_full"></textarea>
                                                </div>
                                                </td>
                                             </tr>
                                             <tr>
                                                <td class="cr_min_width_200">
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("Set the custom taxonomies that will be set for generated posts. The syntax for this field is the following: custom_taxonomy_name1 => custom_taxonomy_value1A, custom_taxonomy_value1B; custom_taxonomy_name2 => custom_taxonomy_value2A, custom_taxonomy_value2B; ... . In custom_taxonomy_valueX, you can use shortcodes. Example (without quotes): 'cats_taxonomy_field => %%item_title%%; tags_taxonomy_field => manualtax2, %%item_title%%'. You can use the following shortcodes: %%item_read_more_button%%, %%item_media%%, %%custom_html%%, %%custom_html2%%, %%random_sentence%%, %%random_sentence2%%, %%random_image[keyword]%%, %%random_image_url[keyword]%%, %%item_title%%, %%item_description%%, %%item_content%%, %%item_content_plain_text%%, %%royalty_free_image_attribution%%, %%item_url%%, %%item_cat%%, %%item_tags%%, %%keyword_search%%, %%item_show_image%%, %%item_image_URL%%, %%author%%, %%author_link%%, %%item_source%%, %%item_source_id%%", 'newsomatic-news-post-generator');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Post Custom Taxonomies:", 'newsomatic-news-post-generator');?></b>&nbsp;<b><a href="https://coderevolution.ro/knowledge-base/faq/post-template-reference-advanced-usage/" target="_blank">&#9432;</a></b>
                                                </td>
                                                <td>
                                                <textarea rows="1" cols="70" name="newsomatic_rules_list[custom_tax][]" placeholder="Please insert your desired custom taxonomies. Example: custom_taxonomy_name => %%item_cats%%" class="cr_width_full"></textarea>
                                                </div>
                                                </td>
                                             </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo esc_html__("Enter a 2 letter language code that will be assigned as the WPML/Polylang language for posts. Example: for German, input: de", 'newsomatic-news-post-generator');
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Assign WPML/Polylang Language to Posts:", 'newsomatic-news-post-generator');?></b>
                                             </td>
                                             <td>
                                             <input type="text" class="cr_width_full" name="newsomatic_rules_list[wpml_lang][]" value="" placeholder="WPML/Polylang language" class="cr_width_full">
                                             </div>
                                             </td>
                                          </tr>
                                             <tr>
                                             <td colspan="2">
                                                <h3><?php echo esc_html__("Full Article Content Importing Options:", 'newsomatic-news-post-generator');?></h3>
                                             </td>
                                             </tr>
                                             <tr>
                                                <td>
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px"><?php echo esc_html__("Do you want to try to get full article content from the linked URL? This will replace the content of the %%item_content%% shortcode.", 'newsomatic-news-post-generator');?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Try to Get Full Article Content:", 'newsomatic-news-post-generator');?></b>
                                                </td>
                                                <td>
                                                <input type="checkbox" id="full_content" name="newsomatic_rules_list[full_content][]">               
                                                </div>
                                                </td>
                                             </tr>
                                              <tr>
                                                 <td>
                                                    <div class="hideFull">
                                                       <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                          <div class="bws_hidden_help_text cr_min_260px"><?php echo esc_html__("Do you want to try to use PhantomJS to try to parse JavaScript from crawled pages (for pages that create dynamic content, on page load, using JavaScript)? Please note that for this to work, you must have PhantomJs installed on your server. You can configure the path to PhantomJS from your server, from plugin's 'Main Settings'.", 'newsomatic-news-post-generator');?>
                                                          </div>
                                                       </div>
                                                       <b><?php echo esc_html__("Content Scraping Method To Use:", 'newsomatic-news-post-generator');?></b><div class="cr_float_right bws_help_box bws_help_box_right dashicons cr_align_middle"><img class="cr_align_middle" src="<?php echo plugins_url('../images/new.png', __FILE__);?>" alt="new feature"/>
                                                          <div class="bws_hidden_help_text cr_min_260px"><?php echo esc_html__("New feature added to this plugin: it is able to use HeadlessBrowserAPI to scrape with JavaScript rendered content any website from the internet. Also, the Tor node of the API will be able to scrape .onion sites from the Dark Net!", 'newsomatic-news-post-generator');?>
                                                          </div>
                                                       </div>
                                                    </div>
                                                 </td>
                                                 <td>
                                                    <div class="hideFull">
                                                       <select id="use_phantom" name="newsomatic_rules_list[use_phantom][]" class="cr_width_full">
                                                        <option value="0" selected><?php echo esc_html__("WordPress (Default)", 'newsomatic-news-post-generator');?></option>
                                                        <option value="1"><?php echo esc_html__("Use PhantomJS", 'newsomatic-news-post-generator');?></option>          
                                                        <option value="2"><?php echo esc_html__("Use Puppeteer", 'newsomatic-news-post-generator');?></option>
                                                        <option value="4"<?php if (!isset($newsomatic_Main_Settings['headlessbrowserapi_key']) || trim($newsomatic_Main_Settings['headlessbrowserapi_key']) == ''){echo ' title="' . esc_html__("This option is disabled. To enable it, add a HeadlessBrowserAPI Key in the plugin's 'Main Settings' menu.", 'newsomatic-news-post-generator') . '" disabled';}?>><?php echo esc_html__("Puppeteer (HeadlessBrowserAPI)", 'newsomatic-news-post-generator');if (!isset($newsomatic_Main_Settings['headlessbrowserapi_key']) || trim($newsomatic_Main_Settings['headlessbrowserapi_key']) == ''){echo esc_html__(' - to enable, add a HeadlessBrowserAPI key in the plugin\'s \'Main Settings\'', 'newsomatic-news-post-generator');}?></option>
                                                        <option value="5"<?php if (!isset($newsomatic_Main_Settings['headlessbrowserapi_key']) || trim($newsomatic_Main_Settings['headlessbrowserapi_key']) == ''){echo ' title="' . esc_html__("This option is disabled. To enable it, add a HeadlessBrowserAPI Key in the plugin's 'Main Settings' menu.", 'newsomatic-news-post-generator') . '" disabled';}?>><?php echo esc_html__("Tor (HeadlessBrowserAPI)", 'newsomatic-news-post-generator');if (!isset($newsomatic_Main_Settings['headlessbrowserapi_key']) || trim($newsomatic_Main_Settings['headlessbrowserapi_key']) == ''){echo esc_html__(' - to enable, add a HeadlessBrowserAPI key in the plugin\'s \'Main Settings\'', 'newsomatic-news-post-generator');}?></option>
                                                        <option value="6"<?php if (!isset($newsomatic_Main_Settings['headlessbrowserapi_key']) || trim($newsomatic_Main_Settings['headlessbrowserapi_key']) == ''){echo ' title="' . esc_html__("This option is disabled. To enable it, add a HeadlessBrowserAPI Key in the plugin's 'Main Settings' menu.", 'newsomatic-news-post-generator') . '" disabled';}?>><?php echo esc_html__("PhantomJS (HeadlessBrowserAPI)", 'newsomatic-news-post-generator');if (!isset($newsomatic_Main_Settings['headlessbrowserapi_key']) || trim($newsomatic_Main_Settings['headlessbrowserapi_key']) == ''){echo esc_html__(' - to enable, add a HeadlessBrowserAPI key in the plugin\'s \'Main Settings\'', 'newsomatic-news-post-generator');}?></option>
                                                       </select>              
                                                    </div>
                                                 </td>
                                              </tr>
                                             <tr>
                                                <td>
                                                   <div class="hideFull">
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo sprintf( wp_kses( __( "Select the query type you want to search for the article full content. XPath: <a href='%s' target='_blank'>More info/tutorial</a>.", 'newsomatic-news-post-generator'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url( 'https://www.w3schools.com/xml/xpath_intro.asp' ) );
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Full Content Query Type (Optional):", 'newsomatic-news-post-generator');?></b>
                                                   </div>
                                                </td>
                                                <td>
                                                   <div class="hideFull">
                                                      <select id="type" name="newsomatic_rules_list[type][]" class="newsomatic_selector cr_width_full" data-source-field-id="date" data-target-field-id="expre" data-target-field-cont="">
                                                         <option value="auto" selected><?php echo esc_html__("Auto Detect", 'newsomatic-news-post-generator');?></option>
                                                         <option value="visual"><?php echo esc_html__("Visual Selector", 'newsomatic-news-post-generator');?></option>
                                                         <option value="id"><?php echo esc_html__("ID", 'newsomatic-news-post-generator');?></option>
                                                         <option value="class"><?php echo esc_html__("Class", 'newsomatic-news-post-generator');?></option>
                                                         <option value="xpath"><?php echo esc_html__("XPath", 'newsomatic-news-post-generator');?></option>
                                                         <option value="regex"><?php echo esc_html__("Regex", 'newsomatic-news-post-generator');?></option>
                                                      </select>
                                                   </div>
                                                </td>
                                             </tr>
                                             <tr>
                                                <td>
                                                   <div class="hideFull">
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo sprintf( wp_kses( __( "Input the search query for full content searching. This can be the ID or class name you want to search, the <a href='%s' target='_blank'>regex expression</a> you want to apply for or the XPath Expression you want to query for. <a href='%s' target='_blank'>More info/tutorial</a>.", 'newsomatic-news-post-generator'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url( 'https://regexone.com/' ), esc_url( 'https://www.w3schools.com/xml/xpath_intro.asp' ) );
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("HTML Search Query String (Optional)", 'newsomatic-news-post-generator');?> <a name="help" href="admin.php?page=newsomatic_helper" target="_blank"><?php echo esc_html__("Help!", 'newsomatic-news-post-generator');?></a>:</b>
                                                   </div>
                                                </td>
                                                <td>
                                                   <div class="hideFull">
                                                      <input type="text" id="expre" name="newsomatic_rules_list[expre][]" value="" placeholder="Please insert your query" class="cr_width_full">
                                                   </div>
                                                </td>
                                             </tr>
                                             <tr>
                                             <td>
                                                <div class="hideFull">
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo sprintf( wp_kses( __( "Input the correct HTML attribute where the image src is found for lazy loaded images that are scraped from the full content. You can also add a comma separated list of multiple lazy loading tags. The attribute containing the actual image URL ex: \"data-src\",\"data-original\"", 'newsomatic-news-post-generator'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url( 'https://regexone.com/' ), esc_url( 'https://www.w3schools.com/xml/xpath_intro.asp' ) );
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Lazy Loading Images HTML Tag", 'newsomatic-news-post-generator');?>:</b>
                                                </div>
                                             </td>
                                             <td>
                                                <div class="hideFull">
                                                   <input type="text" name="newsomatic_rules_list[lazy_tag][]" value="" placeholder="Image lazy load html tag" class="cr_width_full">
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td class="cr_min_width_200">
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo esc_html__("Select the cookie values you want to send with each request. The syntax for this field is the following: cookie_key1=cookie_value1; cookie_key2=cookie_value2 . To disable this feature, leave this field blank.", 'newsomatic-news-post-generator');
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Send Cookies With Request:", 'newsomatic-news-post-generator');?></b>
                                             </td>
                                             <td>
                                             <textarea rows="1" cols="70" id="newsomatic_custom_cookies" name="newsomatic_rules_list[custom_cookies][]" placeholder="Please insert your desired cookies. Example: cookie_key1=cookie_value1; cookie_key2=cookie_value2" class="cr_width_full"></textarea>
                                             </div>
                                             </td>
                                          </tr>
                                             <tr>
                                                <td>
                                                   <div class="hideFull">
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("Select a percentage of the grabbed content that will be included in the article. This is useful when the author states that you can legally get up to 25% of the full article. To disable this feature, leave this field blank.", 'newsomatic-news-post-generator');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Percentage Of The Full Content To Keep:", 'newsomatic-news-post-generator');?></b>
                                                   </div>
                                                </td>
                                                <td>
                                                   <div class="hideFull">
                                                      <input type="number" min="1" step="1" max="100" name="newsomatic_rules_list[content_percent][]" value="" placeholder="Please insert a percentage" class="cr_width_full">
                                                   </div>
                                                </td>
                                             </tr>
                                             <tr>
                                                <td>
                                                   <div class="hideFull">
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px"><?php echo esc_html__("Do you want to get only one element or all elements that fit the defined rule?", 'newsomatic-news-post-generator');?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Get Only The First Found Element:", 'newsomatic-news-post-generator');?></b>
                                                   </div>
                                                </td>
                                                <td>
                                                   <div class="hideFull">
                                                      <input type="checkbox" id="single" name="newsomatic_rules_list[single][]">               
                                                   </div>
                                                </td>
                                             </tr>
                                             <tr>
                                                <td>
                                                   <div class="hideFull">
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px"><?php echo esc_html__("Do you want to get only the inner content of the div or the full div (with tags you searched for)?", 'newsomatic-news-post-generator');?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Get Only The Inner Div Content:", 'newsomatic-news-post-generator');?></b>
                                                   </div>
                                                </td>
                                                <td>
                                                   <div class="hideFull">
                                                      <input type="checkbox" id="inner" name="newsomatic_rules_list[inner][]">               
                                                   </div>
                                                </td>
                                             </tr>
                                             <tr>
                                                <td>
                                                   <div class="hideFull">
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px"><?php echo esc_html__("Select the source page encoding", 'newsomatic-news-post-generator');?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Source Article Encoding:", 'newsomatic-news-post-generator');?></b>
                                                   </div>
                                                </td>
                                                <td>
                                                   <div class="hideFull">
                                                      <select id="encoding" name="newsomatic_rules_list[encoding][]" class="cr_width_full">
                                                         <option value="NO_CHANGE"><?php echo esc_html__("Feature Disabled", 'newsomatic-news-post-generator');?></option>
                                                         <option value="AUTO"><?php echo esc_html__("Auto Detect", 'newsomatic-news-post-generator');?></option>
                                                         <?php
                                                            $i=0;
                                                            foreach($GLOBALS['encodings'] as $enc){
                                                                echo '<option value="' . esc_attr($GLOBALS['encodings'][$i]) . '"'; 
                                                                echo '>' . esc_attr($GLOBALS['encodings'][$i]) . '</option>';
                                                                $i++;
                                                            }
                                                            ?>
                                                      </select>
                                                   </div>
                                                </td>
                                             </tr>
                                             <tr>
                                             <td colspan="2">
                                                <h3><?php echo esc_html__("Post Content Options:", 'newsomatic-news-post-generator');?></h3>
                                             </td>
                                             </tr>
                                             <tr>
                                                <td>
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("Do you want to strip images from generated content?", 'newsomatic-news-post-generator');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Strip Images From Content:", 'newsomatic-news-post-generator');?></b>
                                                </td>
                                                <td>
                                                <input type="checkbox" id="strip_images" name="newsomatic_rules_list[strip_images][]">
                                                </div>
                                                </td>
                                             </tr>
                                             <tr>
                                                <td>
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("Do you want to strip article source from title?", 'newsomatic-news-post-generator');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Strip Article Source From Title:", 'newsomatic-news-post-generator');?></b>
                                                </td>
                                                <td>
                                                <input type="checkbox" id="strip_tsource" name="newsomatic_rules_list[strip_tsource][]" checked>
                                                </div>
                                                </td>
                                             </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo esc_html__("Strip HTML elements from final content that have this IDs. You can insert more IDs, separeted by comma. To disable this feature, leave this field blank.", 'newsomatic-news-post-generator');
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Strip HTML Elements by ID:", 'newsomatic-news-post-generator');?></b>
                                             </td>
                                             <td>
                                             <textarea rows="1" class="cr_width_full" name="newsomatic_rules_list[strip_by_id][]" placeholder="id1, id2, id3" class="cr_width_full"></textarea>
                                             </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo esc_html__("Strip HTML elements from final content that have this class. You can insert more classes, separeted by comma. To disable this feature, leave this field blank.", 'newsomatic-news-post-generator');
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Strip HTML Elements by Class:", 'newsomatic-news-post-generator');?></b>
                                             </td>
                                             <td>
                                             <textarea rows="1" class="cr_width_full" name="newsomatic_rules_list[strip_by_class][]" placeholder="class1, class2, class3" class="cr_width_full"></textarea>
                                             </div>
                                             </td>
                                          </tr>
                                             <tr>
                                                <td>
                                                   <div class="hideFull">
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px"><?php echo esc_html__("Do you want to strip HTML from Full Article Content?", 'newsomatic-news-post-generator');?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Strip HTML From Full Content:", 'newsomatic-news-post-generator');?></b>
                                                   </div>
                                                </td>
                                                <td>
                                                   <div class="hideFull">
                                                      <input type="checkbox" id="only_text" name="newsomatic_rules_list[only_text][]">               
                                                   </div>
                                                </td>
                                             </tr>
											  <tr>
												 <td>
													<div>
													   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
														  <div class="bws_hidden_help_text cr_min_260px">
															 <?php
																echo esc_html__("Set a list of allowed HTML tags, if \'Strip HTML From Full Content\' checkbox is enabled. Ex: &lt;br&gt;&lt;a&gt;", 'newsomatic-news-post-generator');
																?>
														  </div>
													   </div>
													   <b><?php echo esc_html__("Alllowed HTML Tags (If Strip HTML Enabled):", 'newsomatic-news-post-generator');?></b>
												 </td>
												 <td>
												 <textarea rows="1" class="cr_width_full" name="newsomatic_rules_list[allow_html_tags][]" placeholder="HTML tag list" class="cr_width_full"></textarea>
												 </div>
												 </td>
											  </tr>
                                             <tr>
                                                <td>
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("Do you want to limit the title's length to a specific word count? To disable this feature, leave this field blank.", 'newsomatic-news-post-generator');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Limit Title Word Count:", 'newsomatic-news-post-generator');?></b>
                                                </td>
                                                <td>
                                                <input type="number" min="1" step="1" id="limit_title_word_count" name="newsomatic_rules_list[limit_title_word_count][]" value="" placeholder="Please insert a limit for title" class="cr_width_full">
                                                </div>
                                                </td>
                                             </tr>
                                             <tr>
                                                <td>
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("Do you want to limit the content's length to a specific word count? To disable this feature, leave this field blank.", 'newsomatic-news-post-generator');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Limit Content Word Count:", 'newsomatic-news-post-generator');?></b>
                                                </td>
                                                <td>
                                                <input type="number" min="1" step="1" id="limit_content_word_count" name="newsomatic_rules_list[limit_content_word_count][]" value="" placeholder="Please insert a limit for content" class="cr_width_full">
                                                </div>
                                                </td>
                                             </tr>
                                             <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo esc_html__("Run regex on post content. To disable this feature, leave this field blank.", 'newsomatic-news-post-generator');
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Run Regex On Content:", 'newsomatic-news-post-generator');?></b>
                                             </td>
                                             <td>
                                             <textarea rows="1" class="cr_width_full" name="newsomatic_rules_list[strip_by_regex][]" placeholder="regex expression" class="cr_width_full"></textarea>
                                             </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo esc_html__("Replace the above regex matches with this regex expression. If you want to strip matched content, leave this field blank. You can add multiple Regex expressions here, each on a new line.", 'newsomatic-news-post-generator');
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Replace Matches From Regex (Content):", 'newsomatic-news-post-generator');?></b>
                                             </td>
                                             <td>
                                             <textarea rows="1" class="cr_width_full" name="newsomatic_rules_list[replace_regex][]" placeholder="regex replacement" class="cr_width_full"></textarea>
                                             </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo esc_html__("Run regex on post title. To disable this feature, leave this field blank. You can add multiple Regex expressions, each on a different line.", 'rss-feed-post-generator-echo');
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Run Regex On Title:", 'rss-feed-post-generator-echo');?></b>
                                             </td>
                                             <td>
                                             <textarea rows="1" class="cr_width_full" name="newsomatic_rules_list[strip_by_regex_title][]" placeholder="regex expression" class="cr_width_full"></textarea>
                                             </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo esc_html__("Replace the above regex matches with this regex expression. If you want to strip matched content, leave this field blank. You can add multiple replacement expressions, each on a different line (in this case, each will match the corresponding expression from the above Regex field.", 'rss-feed-post-generator-echo');
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Replace Title Matches From Regex:", 'rss-feed-post-generator-echo');?></b>
                                             </td>
                                             <td>
                                             <textarea rows="1" class="cr_width_full" name="newsomatic_rules_list[replace_regex_title][]" placeholder="regex replacement" class="cr_width_full"></textarea>
                                             </div>
                                             </td>
                                          </tr>
                                             <tr>
                                             <td colspan="2">
                                                <h3><?php echo esc_html__("Featured Image Options:", 'newsomatic-news-post-generator');?></h3>
                                             </td>
                                             </tr>
                                             <tr>
                                                <td>
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("Do you want to set featured image for generated post (to the first image that was found in the post)? If you don't check the 'Get Image From Pixabay' checkbox, this will work only when 'Get Full Content' is also checked.", 'newsomatic-news-post-generator');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Auto Get Featured Image:", 'newsomatic-news-post-generator');?></b>
                                                </td>
                                                <td>
                                                <input type="checkbox" id="featured_image" name="newsomatic_rules_list[featured_image][]" checked>
                                                </div>
                                                </td>
                                             </tr>
                                             <tr>
                                                <td>
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("Do you want to skip image returned by NewsomaticAPI and use the image found in the article, instead?", 'newsomatic-news-post-generator');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Skip Image Returned By NewsomaticAPI:", 'newsomatic-news-post-generator');?></b>
                                                </td>
                                                <td>
                                                <input type="checkbox" id="skip_img" name="newsomatic_rules_list[skip_img][]">
                                                </div>
                                                </td>
                                             </tr>
                                             <tr>
                                                <td>
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("Do you want to replace the imported article's image with a royalty free image? Please note that for this feature to function you must configure the plugin (add API keys) in the plugin's 'Main Settings' menu -> 'Royalty Free Featured Image Importing Options' section.", 'newsomatic-news-post-generator');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Replace Article Image With Royalty Free Image:", 'newsomatic-news-post-generator');?></b>
                                                </td>
                                                <td>
                                                <input type="checkbox" id="royalty_free" name="newsomatic_rules_list[royalty_free][]">
                                                </div>
                                                </td>
                                             </tr>
                                          <tr>
                                             <td>
                                                <div class="hideFull">
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px"><?php echo sprintf( wp_kses( __( "Select the query type you want to search for the article featured image. XPath: <a href='%s' target='_blank'>More info/tutorial</a>.", 'newsomatic-news-post-generator'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url( 'https://www.w3schools.com/xml/xpath_intro.asp' ) );?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Featured Image Query Type:", 'newsomatic-news-post-generator');?></b>
                                                </div>
                                             </td>
                                             <td>
                                                <div class="hideFull">
                                                   <select id="image_type" name="newsomatic_rules_list[image_type][]" class="newsomatic_selector cr_width_full" data-source-field-id="date" data-target-field-id="image_expre" data-target-field-cont="">
                                                      <option value="auto" selected><?php echo esc_html__("Auto Detect (From HTML Meta Tags)", 'newsomatic-news-post-generator');?></option>
                                                      <option value="visual"><?php echo esc_html__("Visual Selector", 'newsomatic-news-post-generator');?></option>
                                                      <option value="id"><?php echo esc_html__("ID", 'newsomatic-news-post-generator');?></option>
                                                      <option value="class"><?php echo esc_html__("Class", 'newsomatic-news-post-generator');?></option>
                                                      <option value="xpath"><?php echo esc_html__("XPath", 'newsomatic-news-post-generator');?></option>
                                                      <option value="regex"><?php echo esc_html__("Regex", 'newsomatic-news-post-generator');?></option>
                                                   </select>
                                                </div>
                                             </td>
                                          </tr>
                                          <tr>
                                             <td>
                                                <div class="hideFull">
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo sprintf( wp_kses( __( "Input the search query for featured image searching. This can be the ID or class name you want to search, the <a href='%s' target='_blank'>regex expression</a> you want to apply for or the XPath Expression you want to query for. <a href='%s' target='_blank'>More info/tutorial</a>. If you leave this field blank, the featured will be automatically detected for you.", 'newsomatic-news-post-generator'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url( 'https://regexone.com/' ), esc_url( 'https://www.w3schools.com/xml/xpath_intro.asp' ) );
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Featured Image Search Query String (Optional)", 'newsomatic-news-post-generator');?> <a name="help" href="admin.php?page=newsomatic_helper" target="_blank"><?php echo esc_html__("Help!", 'newsomatic-news-post-generator');?></a>:</b>
                                                </div>
                                             </td>
                                             <td>
                                                <div class="hideFull">
                                                   <input type="text" name="newsomatic_rules_list[image_expre][]" id="image_expre" value="" placeholder="Please insert your query" class="cr_width_full">
                                                </div>
                                             </td>
                                          </tr>
                                             <tr>
                                                <td>
                                                   <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                      <div class="bws_hidden_help_text cr_min_260px">
                                                         <?php
                                                            echo esc_html__("Insert a comma separated list of links to valid images that will be set randomly for the featured image for the posts that do not have a valid image attached or if you disabled automatical featured image generation. You can also use image numeric IDs from images found in the Media Gallery. To disable this feature, leave this field blank. You can also use the %%random_image[keyword]%% shortcode to automatically import a random image from Google Image Search with the Creative Commons filter applied. To get a related image, you can also use: %%random_image[%%item_title%%]%%", 'newsomatic-news-post-generator');
                                                            ?>
                                                      </div>
                                                   </div>
                                                   <b><?php echo esc_html__("Default Featured Image List:", 'newsomatic-news-post-generator');?></b>
                                                </td>
                                                <td>
                                                   <input class="cr_width_60p" type="text" name="newsomatic_rules_list[image_url][]" placeholder="Please insert the link to a valid image" id="cr_input_box"  value=""/>
                                                   <input class="cr_width_33p newsomatic_image_button" type="button" value=">>>"/>
                                                </td>
                                             </tr>
                                             <tr>
                                             <td colspan="2">
                                                <h3><?php echo esc_html__("Translation Options:", 'newsomatic-news-post-generator');?></h3>
                                             </td>
                                             </tr>
                                             <tr>
                                                <td>
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px"><?php echo esc_html__("Do you want to automatically translate generated content using Google Translate? If set, this will overwrite the 'Automatically Translate Content To' option from plugin's 'Main Settings'.", 'newsomatic-news-post-generator');?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Automatically Translate Content To:", 'newsomatic-news-post-generator');?></b><br/><b><?php echo esc_html__("Info:", 'newsomatic-news-post-generator');?></b> <?php echo esc_html__("for translation, the plugin also supports WPML.", 'newsomatic-news-post-generator');?> <b><a href="https://wpml.org/?aid=238195&affiliate_key=ix3LsFyq0xKz" target="_blank"><?php echo esc_html__("Get WPML now!", 'newsomatic-news-post-generator');?></a></b>
                                                </td>
                                                <td>
                                                <select class="cr_width_full" id="translate" name="newsomatic_rules_list[rule_translate][]" >
                                                <?php
                                                   $i = 0;
                                                   foreach ($GLOBALS['language_names'] as $lang) {
                                                       echo '<option value="' . esc_attr($GLOBALS['language_codes'][$i]) . '"';
                                                       if ($i == 0) {
                                                           echo ' selected';
                                                       }
                                                       echo '>' . esc_html($GLOBALS['language_names'][$i]) . '</option>';
                                                       $i++;
                                                   }
                                                   if(isset($newsomatic_Main_Settings['deepl_auth']) && $newsomatic_Main_Settings['deepl_auth'] != '')
                                                   {
                                                       $i = 0;
                                                       foreach ($GLOBALS['language_names_deepl'] as $lang) {
                                                           echo '<option value="' . esc_attr($GLOBALS['language_codes_deepl'][$i]) . '"';
                                                           echo '>' . esc_html($GLOBALS['language_names_deepl'][$i]) . '</option>';
                                                           $i++;
                                                       }
                                                   }
                                                   if(isset($newsomatic_Main_Settings['bing_auth']) && $newsomatic_Main_Settings['bing_auth'] != '')
                                                   {
                                                       $i = 0;
                                                       foreach ($GLOBALS['language_names_bing'] as $lang) {
                                                           echo '<option value="' . esc_attr($GLOBALS['language_codes_bing'][$i]) . '"';
                                                           echo '>' . esc_html($GLOBALS['language_names_bing'][$i]) . '</option>';
                                                           $i++;
                                                       }
                                                   }
                                                   ?>
                                                </select>               
                                                </div>
                                                </td>
                                             </tr>
                                            <tr>
                                                <td>
                                                    <div>
                                                    <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                        <div class="bws_hidden_help_text cr_min_260px"><?php echo esc_html__("Do you want to automatically translate generated content a second time, to this final language? In some cases, this can replace word spinning of scraped content. Please note that this can increase the amount of requests made to the translation APIs. This field has no effect if you don't set also a first translation language, in the settings field from above.", 'newsomatic-news-post-generator');?>
                                                        </div>
                                                    </div>
                                                    <b><?php echo esc_html__("Do Also A Second Translation To:", 'newsomatic-news-post-generator');?></b>
                                                    </div>
                                                </td>
                                                <td>
                                                    <div>
                                                    <select id="second_translate" name="newsomatic_rules_list[second_translate][]" class="cr_width_full">
                                                    <?php
                                                        $i=0;
                                                        foreach($GLOBALS['language_names'] as $lang){
                                                            echo '<option value="' . esc_attr($GLOBALS['language_codes'][$i]) . '"';
                                                            if('disabled' == esc_attr($GLOBALS['language_codes'][$i]))
                                                            {
                                                                echo ' selected';
                                                            }
                                                            echo '>' . esc_html($GLOBALS['language_names'][$i]) . '</option>';
                                                            $i++;
                                                        }
                                                        if(isset($newsomatic_Main_Settings['deepl_auth']) && $newsomatic_Main_Settings['deepl_auth'] != '')
                                                        {
                                                            $i = 0;
                                                            foreach ($GLOBALS['language_names_deepl'] as $lang) {
                                                                echo '<option value="' . esc_attr($GLOBALS['language_codes_deepl'][$i]) . '"';
                                                                echo '>' . esc_html($GLOBALS['language_names_deepl'][$i]) . '</option>';
                                                                $i++;
                                                            }
                                                        }
                                                        if(isset($newsomatic_Main_Settings['bing_auth']) && $newsomatic_Main_Settings['bing_auth'] != '')
                                                        {
                                                            $i = 0;
                                                            foreach ($GLOBALS['language_names_bing'] as $lang) {
                                                                echo '<option value="' . esc_attr($GLOBALS['language_codes_bing'][$i]) . '"';
                                                                echo '>' . esc_html($GLOBALS['language_names_bing'][$i]) . '</option>';
                                                                $i++;
                                                            }
                                                        }
                                                        ?>
                                                    </select>
                                                    </div>
                                                </td>
                                            </tr>
                                             <tr>
                                                <td>
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px"><?php echo esc_html__("Do you want to automatically translate generated content using Google Translate? Here you can define the translation's source language. If set, this will overwrite the 'Automatically Translate Content To' option from plugin's 'Main Settings'.", 'newsomatic-news-post-generator');?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Translation Source Language:", 'newsomatic-news-post-generator');?></b>
                                                </td>
                                                <td>
                                                <select id="translate" class="cr_width_full" name="newsomatic_rules_list[rule_translate_source][]" >
                                                <?php
                                                   $i = 0;
                                                   foreach ($GLOBALS['language_names'] as $lang) {
                                                       echo '<option value="' . esc_attr($GLOBALS['language_codes'][$i]) . '"';
                                                       if ($i == 0) {
                                                           echo ' selected';
                                                       }
                                                       echo '>' . esc_html($GLOBALS['language_names'][$i]) . '</option>';
                                                       $i++;
                                                   }
                                                   if(isset($newsomatic_Main_Settings['deepl_auth']) && $newsomatic_Main_Settings['deepl_auth'] != '')
                                                   {
                                                       $i = 0;
                                                       foreach ($GLOBALS['language_names_deepl'] as $lang) {
                                                           echo '<option value="' . esc_attr($GLOBALS['language_codes_deepl'][$i]) . '"';
                                                           echo '>' . esc_html($GLOBALS['language_names_deepl'][$i]) . '</option>';
                                                           $i++;
                                                       }
                                                   }
                                                   if(isset($newsomatic_Main_Settings['bing_auth']) && $newsomatic_Main_Settings['bing_auth'] != '')
                                                   {
                                                       $i = 0;
                                                       foreach ($GLOBALS['language_names_bing'] as $lang) {
                                                           echo '<option value="' . esc_attr($GLOBALS['language_codes_bing'][$i]) . '"';
                                                           echo '>' . esc_html($GLOBALS['language_names_bing'][$i]) . '</option>';
                                                           $i++;
                                                       }
                                                   }
                                                   ?>
                                                </select>               
                                                </div>
                                                </td>
                                             </tr>
                                             <tr>
                                                <td>
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px"><?php echo esc_html__("Do you want to skip spinning of posts generated by this rule?", 'newsomatic-news-post-generator');?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Do Not Spin Posts Generated By This Rule:", 'newsomatic-news-post-generator');?></b>
                                                </td>
                                                <td>
                                                <input type="checkbox" id="skip_spin_translate" name="newsomatic_rules_list[skip_spin_translate][]">               
                                                </div>
                                                </td>
                                             </tr>
                                             <tr>
                                             <td colspan="2">
                                                <h3><?php echo esc_html__("Miscellaneous Options:", 'newsomatic-news-post-generator');?></h3>
                                             </td>
                                             </tr>
                                             <tr>
                                                <td>
                                                   <div>
                                                      <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                                         <div class="bws_hidden_help_text cr_min_260px">
                                                            <?php
                                                               echo esc_html__("Input a list of keywords that should be ranked for SEO, for keywords generated by this rule. They will be added 1) In the post title (create a specific rule) 2) In the META description for the post 3) In the first sentence of the first paragraph 4) In subheading with an H1 and H2 tag  5) In the Title tag and the ALT tag of the image file name of the main image. To disable this feature, leave this field blank.", 'newsomatic-news-post-generator');
                                                               ?>
                                                         </div>
                                                      </div>
                                                      <b><?php echo esc_html__("Rank These Keywords For SEO in Articles:", 'newsomatic-news-post-generator');?></b>
                                                </td>
                                                <td>
                                                <input type="text" name="newsomatic_rules_list[rank_keywords][]" value="" placeholder="Rank keywords for SEO" class="cr_width_full">
                                                </div>
                                                </td>
                                             </tr>
                                          </table>
                                       </div>
                                    </div>
                                    <div class="codemodalfzr-footer">
                                       <br/>
                                       <h3 class="cr_inline">Newsomatic Automatic Post Generator</h3>
                                       <span id="newsomatic_ok" class="codeokfzr cr_inline">OK&nbsp;</span>
                                       <br/><br/>
                                    </div>
                                 </div>
                              </div>
                           </td>
                           <td class="cr_shrt_td2"><span class="cr_gray20">X</span></td>
                           <td class="cr_short_td"><input type="checkbox" name="newsomatic_rules_list[active][]" value="1" checked />
                              <input type="hidden" name="newsomatic_rules_list[last_run][]" value="1988-01-27 00:00:00"/>
                           </td>
                           <td class="cr_short_td">
                              <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                 <div class="bws_hidden_help_text cr_min_260px">
                                    <?php
                                       echo esc_html__("No info.", 'newsomatic-news-post-generator');
                                       ?>
                                 </div>
                              </div>
                           </td>
                           <td class="cr_center">
                              <div>
                                 <img src="<?php
                                    echo esc_url(plugin_dir_url(dirname(__FILE__)) . 'images/running.gif');
                                    ?>" alt="Running" class="cr_running">
                                 <div class="codemainfzr cr_gray_back">
                                    <select id="actions" class="actions" name="actions" disabled>
                                       <option value="select" disabled selected><?php echo esc_html__("Select an Action", 'newsomatic-news-post-generator');?></option>
                                       <option value="run" onclick=""><?php echo esc_html__("Run This Rule Now", 'newsomatic-news-post-generator');?></option>
                                       <option value="trash" onclick=""><?php echo esc_html__("Move All Posts To Trash", 'newsomatic-news-post-generator');?></option>
                                       <option value="duplicate" onclick=""><?php echo esc_html__("Duplicate This Rule", 'newsomatic-news-post-generator');?></option>
                                       <option value="delete" onclick=""><?php echo esc_html__("Permanently Delete All Posts", 'newsomatic-news-post-generator');?></option>
                                    </select>
                                 </div>
                              </div>
                           </td>
                        </tr>
                     <?php
                        }
                        ?>
                     </tbody>
                  </table>
               </div>
            </div>
         </div>
         <hr/>
         <?php
            $next_url = (newsomatic_isSecure() ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
            if(stristr($next_url, 'newsomatic_page=') === false)
            {
                if(stristr($next_url, '?') === false)
                {
                    if($max_pages == 1)
                    {
                        $next_url .= '?newsomatic_page=1';
                    }
                    else
                    {
                        $next_url .= '?newsomatic_page=2';
                    }
                }
                else
                {
                    if($max_pages == 1)
                    {
                        $next_url .= '&newsomatic_page=1';
                    }
                    else
                    {
                        $next_url .= '&newsomatic_page=2';
                    }
                }
            }
            else
            {
                if(isset($_GET['newsomatic_page']))
                {
                    $curent_page = $_GET["newsomatic_page"];
                }
                else
                {
                    $curent_page = '';
                }
                if(is_numeric($curent_page))
                {
                    $next_page = $curent_page + 1;
                    if($next_page > $max_pages)
                    {
                        $next_page = $max_pages;
                    }
                    if($next_page <= 0)
                    {
                        $next_page = 1;
                    }
                    $next_url = str_replace('newsomatic_page=' . $curent_page, 'newsomatic_page=' . $next_page, $next_url);
                }
                else
                {
                    if(stristr($next_url, '?') === false)
                    {
                        if($max_pages == 1)
                        {
                            $next_url .= '?newsomatic_page=1';
                        }
                        else
                        {
                            $next_url .= '?newsomatic_page=2';
                        }
                    }
                    else
                    {
                        if($max_pages == 1)
                        {
                            $next_url .= '&newsomatic_page=1';
                        }
                        else
                        {
                            $next_url .= '&newsomatic_page=2';
                        }
                    }
                }
            }
            $prev_url = (newsomatic_isSecure() ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
            if(stristr($prev_url, 'newsomatic_page=') === false)
            {
                if(stristr($prev_url, '?') === false)
                {
                    $prev_url .= '?newsomatic_page=1';
                }
                else
                {
                    $prev_url .= '&newsomatic_page=1';
                }
            }
            else
            {
                if(isset($_GET['newsomatic_page']))
                {
                    $curent_page = $_GET["newsomatic_page"];
                }
                else
                {
                    $curent_page = '';
                }
                if(is_numeric($curent_page))
                {
                    $go_to = $curent_page - 1;
                    if($go_to <= 0)
                    {
                        $go_to = 1;
                    }
                    if($go_to > $max_pages)
                    {
                        $go_to = $max_pages;
                    }
                    $prev_url = str_replace('newsomatic_page=' . $curent_page, 'newsomatic_page=' . $go_to, $prev_url);
                }
                else
                {
                    if(stristr($prev_url, '?') === false)
                    {
                        $prev_url .= '?newsomatic_page=1';
                    }
                    else
                    {
                        $prev_url .= '&newsomatic_page=1';
                    }
                }
            }
            $first_url = (newsomatic_isSecure() ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
            if(stristr($first_url, 'newsomatic_page=') === false)
            {
                if(stristr($first_url, '?') === false)
                {
                    $first_url .= '?newsomatic_page=1';
                }
                else
                {
                    $first_url .= '&newsomatic_page=1';
                }
            }
            else
            {
                if(isset($_GET['newsomatic_page']))
                {
                    $curent_page = $_GET["newsomatic_page"];
                }
                else
                {
                    $curent_page = '';
                }
                if(is_numeric($curent_page))
                {
                    $first_url = str_replace('newsomatic_page=' . $curent_page, 'newsomatic_page=1', $first_url);
                }
                else
                {
                    if(stristr($first_url, '?') === false)
                    {
                        $first_url .= '?newsomatic_page=1';
                    }
                    else
                    {
                        $first_url .= '&newsomatic_page=1';
                    }
                }
            }
            $last_url = (newsomatic_isSecure() ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
            if(stristr($last_url, 'newsomatic_page=') === false)
            {
                if(stristr($last_url, '?') === false)
                {
                    $last_url .= '?newsomatic_page=' . $max_pages;
                }
                else
                {
                    $last_url .= '&newsomatic_page=' . $max_pages;
                }
            }
            else
            {
                if(isset($_GET['newsomatic_page']))
                {
                    $curent_page = $_GET["newsomatic_page"];
                }
                else
                {
                    $curent_page = '';
                }
                if(is_numeric($curent_page))
                {
                    $last_url = str_replace('newsomatic_page=' . $curent_page, 'newsomatic_page=' . $max_pages, $last_url);
                }
                else
                {
                    if(stristr($last_url, '?') === false)
                    {
                        $last_url .= '?newsomatic_page=' . $max_pages;
                    }
                    else
                    {
                        $last_url .= '&newsomatic_page=' . $max_pages;
                    }
                }
            }
            if(isset($_GET['newsomatic_page']) && is_numeric($_GET['newsomatic_page']))
            {
                $this_page = $_GET["newsomatic_page"];
            }
            else
            {
                $this_page = '1';
            }
            echo '<center><a href="' . esc_url($first_url) . '">' . esc_html__('First Page', 'newsomatic-news-post-generator') . '</a>&nbsp;&nbsp;&nbsp;<a href="' . esc_url($prev_url) . '">' . esc_html__('Previous Page', 'newsomatic-news-post-generator') . '</a>&nbsp;&nbsp;' . esc_html__('Page', 'newsomatic-news-post-generator') . ' ' . esc_html($this_page) . ' ' . esc_html__('of', 'newsomatic-news-post-generator') . ' ' . esc_html($max_pages) . '&nbsp;-&nbsp;' . esc_html__("Rules Per Page:", 'newsomatic-news-post-generator') . '&nbsp;&nbsp;<input class="cr_50" type="number" min="2" step="1" max="999" name="posts_per_page" value="' . esc_attr($rules_per_page). '" required/>&nbsp;&nbsp;&nbsp;<a href="' . esc_url($next_url) . '">' . esc_html__('Next Page', 'newsomatic-news-post-generator') . '</a>&nbsp;&nbsp;&nbsp;<a href="' . esc_url($last_url) . '">' . esc_html__('Last Page', 'newsomatic-news-post-generator') . '</a></center>
            <center></center>
            <center>Info: You can add new rules only on the last page.</center>';
            ?> 
         <div>
            <p class="submit"><input type="submit" name="btnSubmit" id="btnSubmit" class="button button-primary" onclick="unsaved = false;" value="<?php echo esc_html__("Save Settings", 'newsomatic-news-post-generator');?>"/></p>
         </div>
         <div>
            <a href="https://www.youtube.com/watch?v=5rbnu_uis7Y" target="_blank"><?php echo esc_html__("Nested Shortcodes also supported!", 'newsomatic-news-post-generator');?></a><br/><?php echo esc_html__("Confused about rule running status icons?", 'newsomatic-news-post-generator');?> <a href="http://coderevolution.ro/knowledge-base/faq/how-to-interpret-the-rule-running-visual-indicators-red-x-yellow-diamond-green-tick-from-inside-plugins/" target="_blank"><?php echo esc_html__("More info", 'newsomatic-news-post-generator');?></a><br/>
            <div class="cr_none" id="midas_icons">
               <table>
                  <tr>
                     <td><img id="run_img" src="<?php echo esc_url(plugin_dir_url(dirname(__FILE__)) . 'images/running.gif');?>" alt="Running" title="status"></td>
                     <td><?php echo esc_html__("In Progress", 'newsomatic-news-post-generator');?> - <b><?php echo esc_html__("Importing is Running", 'newsomatic-news-post-generator');?></b></td>
                  </tr>
                  <tr>
                     <td><img id="ok_img" src="<?php echo esc_url(plugin_dir_url(dirname(__FILE__)) . 'images/ok.gif');?>" alt="OK"  title="status"></td>
                     <td><?php echo esc_html__("Success", 'newsomatic-news-post-generator');?> - <b><?php echo esc_html__("New Posts Created", 'newsomatic-news-post-generator');?></b></td>
                  </tr>
                  <tr>
                     <td><img id="fail_img" src="<?php echo esc_url(plugin_dir_url(dirname(__FILE__)) . 'images/failed.gif');?>" alt="Faield" title="status"></td>
                     <td><?php echo esc_html__("Failed", 'newsomatic-news-post-generator');?> - <b><?php echo esc_html__("An Error Occurred.", 'newsomatic-news-post-generator');?> <b><?php echo esc_html__("Please check 'Activity and Logging' plugin menu for details.", 'newsomatic-news-post-generator');?></b></td>
                  </tr>
                  <tr>
                     <td><img id="nochange_img" src="<?php echo esc_url(plugin_dir_url(dirname(__FILE__)) . 'images/nochange.gif');?>" alt="NoChange" title="status"></td>
                     <td><?php echo esc_html__("No Change - No New Posts Created", 'newsomatic-news-post-generator');?> - <b><?php echo esc_html__("Possible reasons:", 'newsomatic-news-post-generator');?></b></td>
                  </tr>
                  <tr>
                     <td></td>
                     <td>
                        <ul>
                           <li>&#9658; <?php echo esc_html__("Already all posts are published that match your search and posts will be posted when new content will be available", 'newsomatic-news-post-generator');?></li>
                           <li>&#9658; <?php echo esc_html__("Some restrictions you defined in the plugin's 'Main Settings'", 'newsomatic-news-post-generator');?> <i>(<?php echo esc_html__("example: 'Minimum Content Word Count', 'Maximum Content Word Count', 'Minimum Title Word Count', 'Maximum Title Word Count', 'Banned Words List', 'Reuired Words List', 'Skip Posts Without Images'", 'newsomatic-news-post-generator');?>)</i> <?php echo esc_html__("prevent posting of new posts.", 'newsomatic-news-post-generator');?></li>
                        </ul>
                     </td>
                  </tr>
               </table>
            </div>
         </div>
      </form>
   </div>
</div>
<?php
   }
   if (isset($_POST['newsomatic_rules_list'])) {
       add_action('admin_init', 'newsomatic_save_rules_manual');
   }
   
   function newsomatic_save_rules_manual($data2)
   {
       check_admin_referer('newsomatic_save_rules', '_newsomaticr_nonce');
       $init_rules_per_page = get_option('newsomatic_posts_per_page', 10);
       $rules_per_page = get_option('newsomatic_posts_per_page', 10);
       if(isset($_POST['posts_per_page']))
       {
           update_option('newsomatic_posts_per_page', $_POST['posts_per_page']);
       }
       $data2 = $_POST['newsomatic_rules_list'];
       $add = false;
       $scad = false;

       $rules  = get_option('newsomatic_rules_list', array());
       if(!is_array($rules))
       {
           $rules = array();
       }
       if(isset($_GET["newsomatic_page"]) && is_numeric($_GET["newsomatic_page"]))
       {
           $curent_page = $_GET["newsomatic_page"];
       }
       else
       {
           $curent_page = 1;
       }
       $offset = ($curent_page - 1) * $rules_per_page;
       $cont  = 0;
       $cat_cont = $offset;
       $exc_cont = $offset;
       $initial_count = count($rules);
       $changes = false;
       if (isset($data2['date'][0])) {
           for ($i = 0; $i < sizeof($data2['date']); ++$i) {
               $bundle = array();
               if (isset($data2['schedule'][$i]) && $data2['schedule'][$i] != '' && $data2['date'][$i] != '') {
                   $bundle[] = trim(sanitize_text_field($data2['limit_title_word_count'][$i]));
                   $bundle[] = trim(sanitize_text_field($data2['schedule'][$i]));
                   if (isset($data2['active'][$i])) {
                       $bundle[] = trim(sanitize_text_field($data2['active'][$i]));
                   } else {
                       $bundle[] = '0';
                   }
                   $bundle[]     = trim(sanitize_text_field($data2['last_run'][$i]));
                   $bundle[]     = trim(sanitize_text_field($data2['submit_status'][$i]));
                   $bundle[]     = trim(sanitize_text_field($data2['default_type'][$i]));
                   $bundle[]     = trim(sanitize_text_field($data2['post_author'][$i]));
                   $bundle[]     = trim(sanitize_text_field($data2['default_tags'][$i]));
                   if($i == sizeof($data2['schedule']) - 1)
                   {
                       if(isset($data2['default_category']))
                       {
                           $bundle[]     = $data2['default_category'];
                       }
                       else
                       {
                           if(!isset($data2['default_category' . $cat_cont]))
                           {
                               $cat_cont++;
                           }
                           if(!isset($data2['default_category' . $cat_cont]))
                           {
                               $bundle[]     = array('newsomatic_no_category_12345678');
                           }
                           else
                           {
                               $bundle[]     = $data2['default_category' . $cat_cont];
                           }
                       }
                   }
                   else
                   {
                       if(!isset($data2['default_category' . $cat_cont]))
                       {
                           $cat_cont++;
                       }
                       if(!isset($data2['default_category' . $cat_cont]))
                       {
                           $bundle[]     = array('newsomatic_no_category_12345678');
                       }
                       else
                       {
                           $bundle[]     = $data2['default_category' . $cat_cont];
                       }
                   }
                   $bundle[]     = trim(sanitize_text_field($data2['auto_categories'][$i]));
                   $bundle[]     = trim(sanitize_text_field($data2['auto_tags'][$i]));
                   $bundle[]     = trim(sanitize_text_field($data2['enable_comments'][$i]));
                   $bundle[]     = trim(sanitize_text_field($data2['featured_image'][$i]));
                   $bundle[]     = trim($data2['image_url'][$i]);
                   $bundle[]     = $data2['post_title'][$i];
                   $bundle[]     = $data2['post_content'][$i];
                   $bundle[]     = trim(sanitize_text_field($data2['enable_pingback'][$i]));
                   $bundle[]     = trim(sanitize_text_field($data2['post_format'][$i]));
                   $bundle[]     = trim($data2['date'][$i]);
                   $bundle[]     = trim(sanitize_text_field($data2['strip_images'][$i]));
                   $bundle[]     = trim(sanitize_text_field($data2['query_string'][$i]));
                   $bundle[]     = trim(sanitize_text_field($data2['max'][$i]));
                   $bundle[]     = trim(sanitize_text_field($data2['full_content'][$i]));
                   $bundle[]     = trim(sanitize_text_field($data2['only_text'][$i]));
                   $bundle[]     = trim(sanitize_text_field($data2['single'][$i]));
                   $bundle[]     = trim(sanitize_text_field($data2['type'][$i]));
                   $bundle[]     = trim(sanitize_text_field($data2['inner'][$i]));
                   $bundle[]     = $data2['expre'][$i];
                   $bundle[]     = trim(sanitize_text_field($data2['lazy_tag'][$i]));
                   $bundle[]     = trim(sanitize_text_field($data2['encoding'][$i]));
                   $bundle[]     = trim(sanitize_text_field($data2['disable_excerpt'][$i]));
                   $bundle[]     = trim(sanitize_text_field($data2['content_percent'][$i]));
                   $bundle[]     = trim(sanitize_text_field($data2['remove_default'][$i]));
                   $bundle[]     = trim(sanitize_text_field($data2['limit_content_word_count'][$i]));
                   $bundle[]     = trim(sanitize_text_field($data2['continue_search'][$i]));
                   $bundle[]     = trim(sanitize_text_field($data2['post_country'][$i]));
                   $bundle[]     = trim(sanitize_text_field($data2['skip_spin_translate'][$i]));
                   $bundle[]     = trim(sanitize_text_field($data2['rule_translate'][$i]));
                   $bundle[]     = trim(sanitize_text_field($data2['rule_translate_source'][$i]));
                   $bundle[]     = trim(sanitize_text_field($data2['rank_keywords'][$i]));
                   $bundle[]     = trim(sanitize_text_field($data2['royalty_free'][$i]));
                   $bundle[]     = trim(sanitize_text_field($data2['import_date'][$i]));
                   $bundle[]     = trim($data2['custom_fields'][$i]);
                   $bundle[]     = trim($data2['custom_tax'][$i]);
                   $bundle[]     = trim(sanitize_text_field($data2['skip_img'][$i]));
                   $bundle[]     = trim(sanitize_text_field($data2['rule_description'][$i]));
                   $bundle[]     = trim(sanitize_text_field($data2['strip_tsource'][$i]));
                   $bundle[]     = trim($data2['strip_by_regex'][$i]);
                   $bundle[]     = trim($data2['replace_regex'][$i]);
                   $bundle[]     = trim($data2['remove_domains'][$i]);
                   $bundle[]     = trim($data2['only_domains'][$i]);
                   $bundle[]     = trim($data2['allow_html_tags'][$i]);
                   $bundle[]     = trim($data2['post_language'][$i]);
                   $bundle[]     = trim($data2['strip_by_id'][$i]);
                   $bundle[]     = trim($data2['strip_by_class'][$i]);
                   $bundle[]     = trim($data2['use_phantom'][$i]);
                   $bundle[]     = trim($data2['wpml_lang'][$i]);
                   $bundle[]     = trim($data2['image_type'][$i]);
                   $bundle[]     = trim($data2['image_expre'][$i]);
                   $bundle[]     = trim($data2['keyword_category'][$i]);
                   $bundle[]     = trim($data2['custom_cookies'][$i]);
                   if($i == sizeof($data2['schedule']) - 1)
                   {
                       if(isset($data2['exclude_country']))
                       {
                           $bundle[]     = $data2['exclude_country'];
                       }
                       else
                       {
                           if(!isset($data2['exclude_country' . $exc_cont]))
                           {
                               $exc_cont++;
                           }
                           if(!isset($data2['exclude_country' . $exc_cont]))
                           {
                               $bundle[]     = array('no_exclude');
                           }
                           else
                           {
                               $bundle[]     = $data2['exclude_country' . $exc_cont];
                           }
                       }
                   }
                   else
                   {
                       if(!isset($data2['exclude_country' . $exc_cont]))
                       {
                           $exc_cont++;
                       }
                       if(!isset($data2['exclude_country' . $exc_cont]))
                       {
                           $bundle[]     = array('no_exclude');
                       }
                       else
                       {
                           $bundle[]     = $data2['exclude_country' . $exc_cont];
                       }
                   }
                   $bundle[]     = trim($data2['second_translate'][$i]);
                   $bundle[]     = trim($data2['strip_by_regex_title'][$i]);
                   $bundle[]     = trim($data2['replace_regex_title'][$i]);
                   $bundle[]     = trim($data2['keyword_tag'][$i]);
                   $rules[$offset + $cont] = $bundle;
                   $cont++;
                   $cat_cont++;
                   $exc_cont++;
               }
           }
           while($cont < $init_rules_per_page)
           {
               if(isset($rules[$offset + $cont]))
               {
                   $rules[$offset + $cont] = false;
               }
               $cont = $cont + 1;
               $cat_cont++;
               $exc_cont++;
               $changes = true;
           }
           $rules = array_values(array_filter($rules));
       }
       if ($changes == false && isset($data2['schedule'][0])) {
           while($cont < $init_rules_per_page)
           {
               if(isset($rules[$offset + $cont]))
               {
                   $rules[$offset + $cont] = false;
               }
               $cont = $cont + 1;
               $cat_cont++;
               $exc_cont++;
               $changes = true;
           }
           if($changes == true)
           {
                $rules = array_values(array_filter($rules));
           }
       }
       update_option('newsomatic_rules_list', $rules, false);
       $final_count = count($rules);
       if($final_count > $initial_count)
       {
           $add = true;
       }
       elseif($final_count < $initial_count)
       {
           $scad = true;
       }
       if(count($rules) % $rules_per_page === 1 && $add === true)
       {
           $rules_count = count($rules);
           $max_pages = ceil($rules_count/$rules_per_page);
           if($max_pages == 0)
           {
               $max_pages = 1;
           }
           $last_url = (newsomatic_isSecure() ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
           if(stristr($last_url, 'newsomatic_page=') === false)
           {
               if(stristr($last_url, '?') === false)
               {
                   $last_url .= '?newsomatic_page=' . $max_pages;
               }
               else
               {
                   $last_url .= '&newsomatic_page=' . $max_pages;
               }
           }
           else
           {
               if(isset($_GET['newsomatic_page']))
               {
                   $curent_page = $_GET["newsomatic_page"];
               }
               else
               {
                   $curent_page = '';
               }
               if(is_numeric($curent_page))
               {
                   $last_url = str_replace('newsomatic_page=' . $curent_page, 'newsomatic_page=' . $max_pages, $last_url);
               }
               else
               {
                   if(stristr($last_url, '?') === false)
                   {
                       $last_url .= '?newsomatic_page=' . $max_pages;
                   }
                   else
                   {
                       $last_url .= '&newsomatic_page=' . $max_pages;
                   }
               }
           }
           newsomatic_redirect($last_url);
       }
       elseif(count($rules) != 0 && count($rules) % $rules_per_page === 0 && $scad === true)
       {
           $rules_count = count($rules);
           $max_pages = ceil($rules_count/$rules_per_page);
           if($max_pages == 0)
           {
               $max_pages = 1;
           }
           $last_url = (newsomatic_isSecure() ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
           if(stristr($last_url, 'newsomatic_page=') === false)
           {
               if(stristr($last_url, '?') === false)
               {
                   $last_url .= '?newsomatic_page=' . $max_pages;
               }
               else
               {
                   $last_url .= '&newsomatic_page=' . $max_pages;
               }
           }
           else
           {
               if(isset($_GET['newsomatic_page']))
               {
                   $curent_page = $_GET["newsomatic_page"];
               }
               else
               {
                   $curent_page = '';
               }
               if(is_numeric($curent_page))
               {
                   $last_url = str_replace('newsomatic_page=' . $curent_page, 'newsomatic_page=' . $max_pages, $last_url);
               }
               else
               {
                   if(stristr($last_url, '?') === false)
                   {
                       $last_url .= '?newsomatic_page=' . $max_pages;
                   }
                   else
                   {
                       $last_url .= '&newsomatic_page=' . $max_pages;
                   }
               }
           }
           newsomatic_redirect($last_url);
       }
   }
   function newsomatic_expand_rules_manual()
   {
       $phantom = false;
       $cat_args   = array(
                   "orderby" => "name",
                   "hide_empty" => 0,
                   "order" => "ASC"
       );
       $categories = get_categories($cat_args);
       $newsomatic_Main_Settings = get_option('newsomatic_Main_Settings', false);
       $GLOBALS['wp_object_cache']->delete('newsomatic_running_list', 'options');
       if (!get_option('newsomatic_running_list', false)) {
           $running = array();
       } else {
           $running = get_option('newsomatic_running_list');
       }
       
       $GLOBALS['wp_object_cache']->delete('newsomatic_rules_list', 'options');
       $rules  = get_option('newsomatic_rules_list');
    if(!is_array($rules))
    {
       $rules = array();
    }
       $output = '';
       $cont   = 0;
       if (!empty($rules)) {
           if(isset($_GET["newsomatic_page"]) && is_numeric($_GET["newsomatic_page"]))
           {
               $curent_page = $_GET["newsomatic_page"];
           }
           else
           {
               $curent_page = 1;
           }
           $posted_items = array();
           $counted_vals = array();
           if (isset($newsomatic_Main_Settings['no_check']) && $newsomatic_Main_Settings['no_check'] == 'on')
           {
           }
           else
           {
               $post_list = array();
               $postsPerPage = 50000;
               $paged = 0;
               do
               {
                   $postOffset = $paged * $postsPerPage;
                   $query = array(
                       'post_status' => array(
                           'publish',
                           'draft',
                           'pending',
                           'trash',
                           'private',
                           'future'
                       ),
                       'post_type' => array(
                           'any'
                       ),
                       'numberposts' => $postsPerPage,
                       'meta_key' => 'newsomatic_parent_rule',
                       'fields' => 'ids',
                       'offset'  => $postOffset
                   );
                   $got_me = get_posts($query);
                   $post_list = array_merge($post_list, $got_me);
                   $paged++;
               }while(!empty($got_me));
               wp_suspend_cache_addition(true);
               foreach ($post_list as $post) {
                   $rule_id = get_post_meta($post, 'newsomatic_parent_rule', true);
                   $exp = explode('-', $rule_id);
                   if(isset($exp[0]) && isset($exp[1]) && $exp[0] == '0')
                   {
                       $posted_items[] = $exp[1];
                   }
               }
               wp_suspend_cache_addition(false);
               $counted_vals = array_count_values($posted_items);
           }
           if(array_sum($counted_vals) > 100)
           {
               $get_me = get_option('newsomatic_rating_trigger', false);
               if($get_me === false)
               {
                   update_option('newsomatic_rating_trigger', '1');
               }
           }
           $unlocker = get_option('newsomatic_minute_running_unlocked', false);
           $rules_per_page = get_option('newsomatic_posts_per_page', 10);
           foreach ($rules as $request => $bundle[]) {
               if(($cont < ($curent_page - 1) * $rules_per_page) || ($cont >= $curent_page * $rules_per_page))
               {
                   $cont++;
                   continue;
               }
               if (isset($counted_vals[$cont])) {
                   $generated_posts = $counted_vals[$cont];
               } else {
                   $generated_posts = 0;
               }
               $bundle_values          = array_values($bundle);
               $myValues               = $bundle_values[$cont];
               $array_my_values        = array_values($myValues);for($iji=0;$iji<count($array_my_values);++$iji){if(is_string($array_my_values[$iji])){$array_my_values[$iji]=stripslashes($array_my_values[$iji]);}}
               $limit_title_word_count = $array_my_values[0];
               $schedule               = $array_my_values[1];
               $active                 = $array_my_values[2];
               $last_run               = $array_my_values[3];
               $status                 = $array_my_values[4];
               $def_type               = $array_my_values[5];
               $post_user_name         = $array_my_values[6];
               $default_tags           = $array_my_values[7];
               $default_category       = $array_my_values[8];
               $auto_categories        = $array_my_values[9];
               $auto_tags              = $array_my_values[10];
               $enable_comments        = $array_my_values[11];
               $featured_image         = $array_my_values[12];
               $image_url              = $array_my_values[13];
               $post_title             = $array_my_values[14];
               $post_content           = $array_my_values[15];
               $enable_pingback        = $array_my_values[16];
               $post_format            = $array_my_values[17];
               $date                   = $array_my_values[18];
               $strip_images           = $array_my_values[19];
               $query_string           = $array_my_values[20];
               $max                    = $array_my_values[21];
               $full_content           = $array_my_values[22];
               $only_text              = $array_my_values[23];
               $single                 = $array_my_values[24];
               $type                   = $array_my_values[25];
               $inner                  = $array_my_values[26];
               $expre                  = $array_my_values[27];
               $lazy_tag                = $array_my_values[28];
               $encoding               = $array_my_values[29];
               $disable_excerpt        = $array_my_values[30];
               $content_percent        = $array_my_values[31];
               $remove_default         = $array_my_values[32];
               $limit_content_word_count= $array_my_values[33];
               $continue_search        = $array_my_values[34];
               $post_country           = $array_my_values[35];
               $skip_spin_translate    = $array_my_values[36];
               $rule_translate         = $array_my_values[37];
               $rule_translate_source  = $array_my_values[38];
               $rank_keywords          = $array_my_values[39];
               $royalty_free           = $array_my_values[40];
               $import_date            = $array_my_values[41];
               $custom_fields          = $array_my_values[42];
               $custom_tax             = $array_my_values[43];
               $skip_img               = $array_my_values[44];
               $rule_description       = $array_my_values[45];
               $strip_tsource          = $array_my_values[46];
               $strip_by_regex         = $array_my_values[47];
               $replace_regex          = $array_my_values[48];
               $remove_domains         = $array_my_values[49];
               $only_domains           = $array_my_values[50];
               $allow_html_tags        = $array_my_values[51];
               $post_language          = $array_my_values[52];
               $strip_by_id            = $array_my_values[53];
               $strip_by_class         = $array_my_values[54];
               $use_phantom            = $array_my_values[55];
               $wpml_lang              = $array_my_values[56];
               $image_type             = $array_my_values[57];
               $image_expre            = $array_my_values[58];
               $keyword_category       = $array_my_values[59];
               $custom_cookies         = $array_my_values[60];
               $exclude_country        = $array_my_values[61];
               $second_translate       = $array_my_values[62];
               $strip_by_regex_title   = $array_my_values[63];
               $replace_regex_title    = $array_my_values[64];
               $keyword_tag            = $array_my_values[65];
               if($rule_description == '')
               {
                  $rule_description = $cont;
               }
               wp_add_inline_script('newsomatic-footer-script', 'createAdmin(' . esc_html($cont) . ');', 'after');
               $output .= '<tr>
                           <td class="cr_short_td"><input type="text" name="newsomatic_rules_list[rule_description][]" id="rule_description' . esc_html($cont) . '" class="cr_center" placeholder="Rule ID" value="' . esc_html($rule_description) . '" class="cr_width_full"/>';
               $output .= '</td>
                           <td class="cr_sz"><select id="date' . esc_html($cont) . '" name="newsomatic_rules_list[date][]" class="newsomatic_select2 cr_width_full">';
   $output .= '<option value="any"';
           if($date == 'any')
           {
               $output .= ' selected';
           }
           $output .= '>' . esc_html__("Any", 'newsomatic-news-post-generator') . '</option>
           <option value="category-business"';
           if($date == 'category-business')
           {
               $output .= ' selected';
           }
           $output .= '>' . esc_html__("Category - Business", 'newsomatic-news-post-generator') . '</option>
   <option value="category-entertainment"';
           if($date == 'category-entertainment')
           {
               $output .= ' selected';
           }
           $output .= '>' . esc_html__("Category - Entertainment", 'newsomatic-news-post-generator') . '</option> 
   <option value="category-general"';
           if($date == 'category-general')
           {
               $output .= ' selected';
           }
           $output .= '>' . esc_html__("Category - General", 'newsomatic-news-post-generator') . '</option> 
   <option value="category-health-and-medical"';
           if($date == 'category-health-and-medical')
           {
               $output .= ' selected';
           }
           $output .= '>' . esc_html__("Category - Health and Medical", 'newsomatic-news-post-generator') . '</option> 
   <option value="category-science-and-nature"';
           if($date == 'category-science-and-nature')
           {
               $output .= ' selected';
           }
           $output .= '>' . esc_html__("Category - Science and Nature", 'newsomatic-news-post-generator') . '</option> 
   <option value="category-sport"';
           if($date == 'category-sport')
           {
               $output .= ' selected';
           }
           $output .= '>' . esc_html__("Category - Sport", 'newsomatic-news-post-generator') . '</option> 
   <option value="category-technology"';
           if($date == 'category-technology')
           {
               $output .= ' selected';
           }
           $output .= '>' . esc_html__("Category - Technology", 'newsomatic-news-post-generator') . '</option>';
           $cats = newsomatic_get_categories();
           if($cats !== false && isset($cats['category_list']) && is_array($cats['category_list']))
           {
               foreach($cats['category_list'] as $key => $cat)
               {
                   $output .= '<option value="' . esc_attr($key) . '"';
                   if($date == $key)
                   {
                       $output .= ' selected';
                   }
                   $output .= '>' . esc_html($cat) . '</option>';
               }
           }
   $output .= '</select></td>
   						<td class="cr_comm_td"><input type="number" step="1" min="1" placeholder="# h" name="newsomatic_rules_list[schedule][]" max="8765812" value="' . esc_attr($schedule) . '" class="cr_width_60" required></td>
                           <td class="cr_comm_td"><input type="number" step="1" min="0" placeholder="# max" max="100" name="newsomatic_rules_list[max][]" value="' . esc_attr($max) . '"  class="cr_width_60" required></td>
                       <td class="cr_width_70">
                       <input type="button" id="mybtnfzr' . esc_html($cont) . '" value="Settings">
                       <div id="mymodalfzr' . esc_html($cont) . '" class="codemodalfzr">
     <div class="codemodalfzr-content">
       <div class="codemodalfzr-header">
         <span id="newsomatic_close' . esc_html($cont) . '" class="codeclosefzr">&times;</span>
         <h2>' . esc_html__('Rule', 'newsomatic-news-post-generator') . ' <span class="cr_color_white">ID ' . esc_html($cont) . '</span> ' . esc_html__('Advanced Settings', 'newsomatic-news-post-generator') . '</h2>
       </div>
       <div class="codemodalfzr-body">
       <div class="table-responsive">
         <table class="responsive table cr_main_table_nowr">
         <tr><td colspan="2">
       <h3>' . esc_html__("NewsomaticAPI Advanced Settings:", 'newsomatic-news-post-generator') . '</h3></td></tr>
       </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Do you want to filter results based on a query string? Please note that only keywords are supported here (no phrase search). If you wish to use phrase search, please go to the \'Custom News to Posts\' plugin menu and configure a rule there.", 'newsomatic-news-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Search Query String", 'newsomatic-news-post-generator') . ':</b>
                       
                       </td><td>
                       <input type="text" id="query_string' . $cont . '" name="newsomatic_rules_list[query_string][]" value="' . esc_attr($query_string) . '" placeholder="Please insert a query string from which to get results" class="cr_width_full">
                           
           </div>
           </td></tr><tr><td class="cr_min_width_200">
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Select if you wish to filter the country of the generated posts. Will work only if you import post from news categories.", 'newsomatic-news-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Generated Post Country", 'newsomatic-news-post-generator') . ':</b>   
                       </td><td class="cr_min_width_200">
                       <select id="post_country" name="newsomatic_rules_list[post_country][]" class="cr_width_full">
                       <option value="all"';
               if ($post_country == 'all') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("All", 'newsomatic-news-post-generator') . '</option>
                       <option value="ar"';
               if ($post_country == 'ar') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Argentina", 'newsomatic-news-post-generator') . '</option>
                       <option value="au"';
               if ($post_country == 'au') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Australia", 'newsomatic-news-post-generator') . '</option>
                       <option value="br"';
               if ($post_country == 'br') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Brazil", 'newsomatic-news-post-generator') . '</option>
                       <option value="ca"';
               if ($post_country == 'ca') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Canada", 'newsomatic-news-post-generator') . '</option>
                       <option value="cn"';
               if ($post_country == 'cn') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("China", 'newsomatic-news-post-generator') . '</option>
                       <option value="cz"';
               if ($post_country == 'cz') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Czech Republic", 'newsomatic-news-post-generator') . '</option>
                       <option value="de"';
               if ($post_country == 'de') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Germany", 'newsomatic-news-post-generator') . '</option>
                       <option value="es"';
               if ($post_country == 'es') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Spain", 'newsomatic-news-post-generator') . '</option>
                       <option value="fr"';
               if ($post_country == 'fr') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("France", 'newsomatic-news-post-generator') . '</option>
                       <option value="gb"';
               if ($post_country == 'gb') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Great Britain", 'newsomatic-news-post-generator') . '</option>
                       <option value="ie"';
               if ($post_country == 'ie') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Republic of Ireland", 'newsomatic-news-post-generator') . '</option>
                       <option value="in"';
               if ($post_country == 'in') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("India", 'newsomatic-news-post-generator') . '</option>
                       <option value="it"';
               if ($post_country == 'it') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Italy", 'newsomatic-news-post-generator') . '</option>
                       <option value="nl"';
               if ($post_country == 'nl') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Netherlands", 'newsomatic-news-post-generator') . '</option>
                       <option value="no"';
               if ($post_country == 'no') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Norway", 'newsomatic-news-post-generator') . '</option>
                       <option value="pk"';
               if ($post_country == 'pk') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Pakistan", 'newsomatic-news-post-generator') . '</option>
                       <option value="ru"';
               if ($post_country == 'ru') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Russia", 'newsomatic-news-post-generator') . '</option>
                       <option value="sa"';
               if ($post_country == 'sa') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Saudi Arabia", 'newsomatic-news-post-generator') . '</option>
                       <option value="se"';
               if ($post_country == 'se') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Sweden", 'newsomatic-news-post-generator') . '</option>
                       <option value="us"';
               if ($post_country == 'us') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("United States", 'newsomatic-news-post-generator') . '</option>
                       <option value="za"';
               if ($post_country == 'za') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("South Africa", 'newsomatic-news-post-generator') . '</option>
               <option value="ae"';
               if ($post_country == 'ae') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("United Arab Emirates", 'newsomatic-news-post-generator') . '</option>
                       <option value="at"';
               if ($post_country == 'at') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Austria", 'newsomatic-news-post-generator') . '</option>
                       <option value="be"';
               if ($post_country == 'be') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Belgium", 'newsomatic-news-post-generator') . '</option>
                       <option value="bg"';
               if ($post_country == 'bg') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Bulgaria", 'newsomatic-news-post-generator') . '</option>
                       <option value="ch"';
               if ($post_country == 'ch') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Switzerland", 'newsomatic-news-post-generator') . '</option>
                       <option value="co"';
               if ($post_country == 'co') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Colombia", 'newsomatic-news-post-generator') . '</option>
                       <option value="cu"';
               if ($post_country == 'cu') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Cuba", 'newsomatic-news-post-generator') . '</option>
                       <option value="eg"';
               if ($post_country == 'eg') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Egypt", 'newsomatic-news-post-generator') . '</option>
                       <option value="gh"';
               if ($post_country == 'gh') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Ghana", 'newsomatic-news-post-generator') . '</option>
                       <option value="gr"';
               if ($post_country == 'gr') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Greece", 'newsomatic-news-post-generator') . '</option>
                       <option value="hk"';
               if ($post_country == 'hk') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Hong Kong", 'newsomatic-news-post-generator') . '</option>
                       <option value="hu"';
               if ($post_country == 'hu') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Hungary", 'newsomatic-news-post-generator') . '</option>
                       <option value="id"';
               if ($post_country == 'id') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Indonesia", 'newsomatic-news-post-generator') . '</option>
                       <option value="is"';
               if ($post_country == 'is') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Israel", 'newsomatic-news-post-generator') . '</option>
                       <option value="jp"';
               if ($post_country == 'jp') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Japan", 'newsomatic-news-post-generator') . '</option>
                       <option value="kr"';
               if ($post_country == 'kr') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("South Korea", 'newsomatic-news-post-generator') . '</option>
                       <option value="lt"';
               if ($post_country == 'lt') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Lithuania", 'newsomatic-news-post-generator') . '</option>
                       <option value="lv"';
               if ($post_country == 'lv') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Latvia", 'newsomatic-news-post-generator') . '</option>
                       <option value="ma"';
               if ($post_country == 'ma') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Morocco", 'newsomatic-news-post-generator') . '</option>
                       <option value="mx"';
               if ($post_country == 'mx') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Mexico", 'newsomatic-news-post-generator') . '</option>
                       <option value="my"';
               if ($post_country == 'my') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Malaysia", 'newsomatic-news-post-generator') . '</option>
                       <option value="ng"';
               if ($post_country == 'ng') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Nigeria", 'newsomatic-news-post-generator') . '</option>
                       <option value="nz"';
               if ($post_country == 'nz') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("New Zealand", 'newsomatic-news-post-generator') . '</option>
                       <option value="pe"';
               if ($post_country == 'pe') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Peru", 'newsomatic-news-post-generator') . '</option>
                       <option value="ph"';
               if ($post_country == 'ph') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Philippines", 'newsomatic-news-post-generator') . '</option>
                       <option value="pl"';
               if ($post_country == 'pl') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Poland", 'newsomatic-news-post-generator') . '</option>
                       <option value="pt"';
               if ($post_country == 'pt') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Portugal", 'newsomatic-news-post-generator') . '</option>
                       <option value="ro"';
               if ($post_country == 'ro') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Romania", 'newsomatic-news-post-generator') . '</option>
                       <option value="rs"';
               if ($post_country == 'rs') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Serbia", 'newsomatic-news-post-generator') . '</option>
                       <option value="sg"';
               if ($post_country == 'sg') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Singapore", 'newsomatic-news-post-generator') . '</option>
                       <option value="si"';
               if ($post_country == 'si') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Slovenia", 'newsomatic-news-post-generator') . '</option>
                       <option value="sk"';
               if ($post_country == 'sk') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Slovakia", 'newsomatic-news-post-generator') . '</option>
                       <option value="th"';
               if ($post_country == 'th') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Thailand", 'newsomatic-news-post-generator') . '</option>
                       <option value="tr"';
               if ($post_country == 'tr') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Turkey", 'newsomatic-news-post-generator') . '</option>
                       <option value="tt"';
               if ($post_country == 'tt') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Trinidad and Tobago", 'newsomatic-news-post-generator') . '</option>
                       <option value="tw"';
               if ($post_country == 'tw') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Taiwan", 'newsomatic-news-post-generator') . '</option>
                       <option value="ua"';
               if ($post_country == 'ua') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Ukraine", 'newsomatic-news-post-generator') . '</option>
                       <option value="ve"';
               if ($post_country == 've') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Venezuela", 'newsomatic-news-post-generator') . '</option>
                       <option value="vn"';
               if ($post_country == 'vn') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Vietnam", 'newsomatic-news-post-generator') . '</option>
                   </select>     
           </div>
           </td></tr><tr><td class="cr_min_width_200">
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Select if you wish to exclude the list of countries from below. You can add a maximum of 5 countries to exclude. To disable country exclusion, leave this field blank. This will work only if you import post from Any source (applicable only for NewsomaticAPI).", 'newsomatic-news-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Exclude Countries", 'newsomatic-news-post-generator') . ':</b>   
                       </td><td class="cr_min_width_200">
                       <select id="exclude_country" class="max_5val" name="newsomatic_rules_list[exclude_country' . esc_html($cont) . '][]" multiple ';
                       if (isset($newsomatic_Main_Settings['newsapi_active']) && trim($newsomatic_Main_Settings['newsapi_active']) == 'on'){$output .= ' disabled ';}
                       $output .= 'class="cr_width_full">
                       <option value="no_exclude"';
                       if(!is_array($exclude_country))
                       {
                           $exclude_country = array($exclude_country);
                       }
                       if(count($exclude_country) == 1)
                       {
                        foreach($exclude_country as $dc)
                        {
                            if ("no_exclude" == $dc) {
                                $output .= ' selected';
                            }
                        }
                       }
                       $output .= '>' . esc_html__("Do Not Exclude Countries", 'newsomatic-news-post-generator') . '</option>
                       <option value="ar"';
               if (in_array('ar', $exclude_country)) {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Argentina", 'newsomatic-news-post-generator') . '</option>
                       <option value="au"';
               if (in_array('au', $exclude_country)) {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Australia", 'newsomatic-news-post-generator') . '</option>
                       <option value="br"';
               if (in_array('br', $exclude_country)) {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Brazil", 'newsomatic-news-post-generator') . '</option>
                       <option value="ca"';
               if (in_array('ca', $exclude_country)) {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Canada", 'newsomatic-news-post-generator') . '</option>
                       <option value="cn"';
               if (in_array('cn', $exclude_country)) {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("China", 'newsomatic-news-post-generator') . '</option>
                       <option value="cz"';
               if (in_array('cz', $exclude_country)) {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Czech Republic", 'newsomatic-news-post-generator') . '</option>
                       <option value="de"';
               if (in_array('de', $exclude_country)) {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Germany", 'newsomatic-news-post-generator') . '</option>
                       <option value="es"';
               if (in_array('es', $exclude_country)) {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Spain", 'newsomatic-news-post-generator') . '</option>
                       <option value="fr"';
               if (in_array('fr', $exclude_country)) {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("France", 'newsomatic-news-post-generator') . '</option>
                       <option value="gb"';
               if (in_array('gb', $exclude_country)) {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Great Britain", 'newsomatic-news-post-generator') . '</option>
                       <option value="ie"';
               if (in_array('ie', $exclude_country)) {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Republic of Ireland", 'newsomatic-news-post-generator') . '</option>
                       <option value="in"';
               if (in_array('in', $exclude_country)) {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("India", 'newsomatic-news-post-generator') . '</option>
                       <option value="it"';
               if (in_array('it', $exclude_country)) {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Italy", 'newsomatic-news-post-generator') . '</option>
                       <option value="nl"';
               if (in_array('nl', $exclude_country)) {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Netherlands", 'newsomatic-news-post-generator') . '</option>
                       <option value="no"';
               if (in_array('no', $exclude_country)) {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Norway", 'newsomatic-news-post-generator') . '</option>
                       <option value="pk"';
               if (in_array('pk', $exclude_country)) {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Pakistan", 'newsomatic-news-post-generator') . '</option>
                       <option value="ru"';
               if (in_array('ru', $exclude_country)) {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Russia", 'newsomatic-news-post-generator') . '</option>
                       <option value="sa"';
               if (in_array('sa', $exclude_country)) {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Saudi Arabia", 'newsomatic-news-post-generator') . '</option>
                       <option value="se"';
               if (in_array('se', $exclude_country)) {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Sweden", 'newsomatic-news-post-generator') . '</option>
                       <option value="us"';
               if (in_array('us', $exclude_country)) {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("United States", 'newsomatic-news-post-generator') . '</option>
                       <option value="za"';
               if (in_array('za', $exclude_country)) {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("South Africa", 'newsomatic-news-post-generator') . '</option>
                       <option value="ae"';
               if (in_array('ae', $exclude_country)) {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("United Arab Emirates", 'newsomatic-news-post-generator') . '</option>
                       <option value="at"';
               if (in_array('at', $exclude_country)) {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Austria", 'newsomatic-news-post-generator') . '</option>
                       <option value="be"';
               if (in_array('be', $exclude_country)) {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Belgium", 'newsomatic-news-post-generator') . '</option>
                       <option value="bg"';
               if (in_array('bg', $exclude_country)) {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Bulgaria", 'newsomatic-news-post-generator') . '</option>
                       <option value="ch"';
               if (in_array('ch', $exclude_country)) {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Switzerland", 'newsomatic-news-post-generator') . '</option>
                       <option value="co"';
               if (in_array('co', $exclude_country)) {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Colombia", 'newsomatic-news-post-generator') . '</option>
                       <option value="cu"';
               if (in_array('cu', $exclude_country)) {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Cuba", 'newsomatic-news-post-generator') . '</option>
                       <option value="eg"';
               if (in_array('eg', $exclude_country)) {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Egypt", 'newsomatic-news-post-generator') . '</option>
                        <option value="gh"';
               if (in_array('gh', $exclude_country)) {
                    $output .= ' selected';
               }
               $output .= '>' . esc_html__("Ghana", 'newsomatic-news-post-generator') . '</option>
                       <option value="gr"';
               if (in_array('gr', $exclude_country)) {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Greece", 'newsomatic-news-post-generator') . '</option>
                       <option value="hk"';
               if (in_array('hk', $exclude_country)) {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Hong Kong", 'newsomatic-news-post-generator') . '</option>
                       <option value="hu"';
               if (in_array('hu', $exclude_country)) {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Hungary", 'newsomatic-news-post-generator') . '</option>
                       <option value="id"';
               if (in_array('id', $exclude_country)) {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Indonesia", 'newsomatic-news-post-generator') . '</option>
                       <option value="is"';
               if (in_array('is', $exclude_country)) {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Israel", 'newsomatic-news-post-generator') . '</option>
                       <option value="jp"';
               if (in_array('jp', $exclude_country)) {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Japan", 'newsomatic-news-post-generator') . '</option>
                       <option value="kr"';
               if (in_array('kr', $exclude_country)) {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("South Korea", 'newsomatic-news-post-generator') . '</option>
                       <option value="lt"';
               if (in_array('lt', $exclude_country)) {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Lithuania", 'newsomatic-news-post-generator') . '</option>
                       <option value="lv"';
               if (in_array('lv', $exclude_country)) {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Latvia", 'newsomatic-news-post-generator') . '</option>
                       <option value="ma"';
               if (in_array('ma', $exclude_country)) {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Morocco", 'newsomatic-news-post-generator') . '</option>
                       <option value="mx"';
               if (in_array('mx', $exclude_country)) {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Mexico", 'newsomatic-news-post-generator') . '</option>
                       <option value="my"';
               if (in_array('my', $exclude_country)) {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Malaysia", 'newsomatic-news-post-generator') . '</option>
                       <option value="ng"';
               if (in_array('ng', $exclude_country)) {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Nigeria", 'newsomatic-news-post-generator') . '</option>
                       <option value="nz"';
               if (in_array('nz', $exclude_country)) {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("New Zealand", 'newsomatic-news-post-generator') . '</option>
                       <option value="pe"';
               if (in_array('pe', $exclude_country)) {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Peru", 'newsomatic-news-post-generator') . '</option>
                       <option value="ph"';
               if (in_array('ph', $exclude_country)) {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Philippines", 'newsomatic-news-post-generator') . '</option>
                       <option value="pl"';
               if (in_array('pl', $exclude_country)) {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Poland", 'newsomatic-news-post-generator') . '</option>
                       <option value="pt"';
               if (in_array('pt', $exclude_country)) {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Portugal", 'newsomatic-news-post-generator') . '</option>
                       <option value="ro"';
               if (in_array('ro', $exclude_country)) {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Romania", 'newsomatic-news-post-generator') . '</option>
                       <option value="rs"';
               if (in_array('rs', $exclude_country)) {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Serbia", 'newsomatic-news-post-generator') . '</option>
                       <option value="sg"';
               if (in_array('sg', $exclude_country)) {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Singapore", 'newsomatic-news-post-generator') . '</option>
                       <option value="si"';
               if (in_array('si', $exclude_country)) {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Slovenia", 'newsomatic-news-post-generator') . '</option>
                       <option value="sk"';
               if (in_array('sk', $exclude_country)) {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Slovakia", 'newsomatic-news-post-generator') . '</option>
                       <option value="th"';
               if (in_array('th', $exclude_country)) {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Thailand", 'newsomatic-news-post-generator') . '</option>
                       <option value="tr"';
               if (in_array('tr', $exclude_country)) {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Turkey", 'newsomatic-news-post-generator') . '</option>
                       <option value="tt"';
               if (in_array('tt', $exclude_country)) {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Trinidad and Tobago", 'newsomatic-news-post-generator') . '</option>
                       <option value="tw"';
               if (in_array('tw', $exclude_country)) {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Taiwan", 'newsomatic-news-post-generator') . '</option>
                       <option value="ua"';
               if (in_array('ua', $exclude_country)) {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Ukraine", 'newsomatic-news-post-generator') . '</option>
                       <option value="ve"';
               if (in_array('ve', $exclude_country)) {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Venezuela", 'newsomatic-news-post-generator') . '</option>
                       <option value="vn"';
               if (in_array('vn', $exclude_country)) {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Vietnam", 'newsomatic-news-post-generator') . '</option>
                   </select>     
           </div>
           </td></tr><tr><td class="cr_min_width_200">
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Select if you wish to filter the language of the generated posts. Will work only if you import post from Any or from categories (applicable only for NewsomaticAPI)", 'newsomatic-news-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Generated Post Language", 'newsomatic-news-post-generator') . ':</b>   
                       </td><td class="cr_min_width_200">
                       <select id="post_language" name="newsomatic_rules_list[post_language][]" ';
                       if (isset($newsomatic_Main_Settings['newsapi_active']) && trim($newsomatic_Main_Settings['newsapi_active']) == 'on'){$output .= ' disabled ';}
                       $output .= 'class="cr_width_full">
                       <option value="all"';
               if ($post_language == '' || $post_language == 'all') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("All", 'newsomatic-news-post-generator') . '</option>
                       <option value="en"';
               if ($post_language == 'en') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("English", 'newsomatic-news-post-generator') . '</option>
                       <option value="cz"';
               if ($post_language == 'cz') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Czech", 'newsomatic-news-post-generator') . '</option>
                       <option value="ar"';
               if ($post_language == 'ar') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Arabic", 'newsomatic-news-post-generator') . '</option>
                       <option value="bg"';
               if ($post_language == 'bg') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Bulgarian", 'newsomatic-news-post-generator') . '</option>
                       <option value="zh"';
               if ($post_language == 'zh') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Chinese", 'newsomatic-news-post-generator') . '</option>
                       <option value="de"';
               if ($post_language == 'de') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("German", 'newsomatic-news-post-generator') . '</option>
                       <option value="es"';
               if ($post_language == 'es') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Spanish", 'newsomatic-news-post-generator') . '</option>
                       <option value="fr"';
               if ($post_language == 'fr') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("French", 'newsomatic-news-post-generator') . '</option>
                       <option value="gr"';
               if ($post_language == 'gr') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Greek", 'newsomatic-news-post-generator') . '</option>
                       <option value="he"';
               if ($post_language == 'he') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Hebrew", 'newsomatic-news-post-generator') . '</option>
                       <option value="hu"';
               if ($post_language == 'hu') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Hungarian", 'newsomatic-news-post-generator') . '</option>
                       <option value="hd"';
               if ($post_language == 'hd') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Hindi", 'newsomatic-news-post-generator') . '</option>
                       <option value="id"';
               if ($post_language == 'id') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Indonesian", 'newsomatic-news-post-generator') . '</option>
                       <option value="it"';
               if ($post_language == 'it') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Italian", 'newsomatic-news-post-generator') . '</option>
                       <option value="kr"';
               if ($post_language == 'kr') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Korean", 'newsomatic-news-post-generator') . '</option>
                       <option value="lv"';
               if ($post_language == 'lv') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Latvian", 'newsomatic-news-post-generator') . '</option>
                       <option value="lt"';
               if ($post_language == 'lt') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Lithuanian", 'newsomatic-news-post-generator') . '</option>
                       <option value="pl"';
               if ($post_language == 'pl') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Polish", 'newsomatic-news-post-generator') . '</option>
                       <option value="ro"';
               if ($post_language == 'ro') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Romanian", 'newsomatic-news-post-generator') . '</option>
                       <option value="cr"';
               if ($post_language == 'cr') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Croatian", 'newsomatic-news-post-generator') . '</option>
                       <option value="rs"';
               if ($post_language == 'rs') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Bosnian", 'newsomatic-news-post-generator') . '</option>
                       <option value="sx"';
               if ($post_language == 'sx') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Serbian", 'newsomatic-news-post-generator') . '</option>
                       <option value="si"';
               if ($post_language == 'si') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Slovenian", 'newsomatic-news-post-generator') . '</option>
                       <option value="sk"';
               if ($post_language == 'sk') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Slovak", 'newsomatic-news-post-generator') . '</option>
                       <option value="nl"';
               if ($post_language == 'nl') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Dutch", 'newsomatic-news-post-generator') . '</option>
                       <option value="no"';
               if ($post_language == 'no') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Norwegian", 'newsomatic-news-post-generator') . '</option>
                       <option value="pt"';
               if ($post_language == 'pt') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Portuguese", 'newsomatic-news-post-generator') . '</option>
                       <option value="ru"';
               if ($post_language == 'ru') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Russian", 'newsomatic-news-post-generator') . '</option>
                       <option value="se"';
               if ($post_language == 'se') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Swedish", 'newsomatic-news-post-generator') . '</option>
                       <option value="ud"';
               if ($post_language == 'ud') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Urdu", 'newsomatic-news-post-generator') . '</option>
                       <option value="vn"';
               if ($post_language == 'vn') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Vietnamese", 'newsomatic-news-post-generator') . '</option>
                   </select>     
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("A comma-separated string of domains (eg bbc.co.uk,techcrunch.com,engadget.com) to restrict the search to.", 'newsomatic-news-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Include Only These Domains in Results", 'newsomatic-news-post-generator') . ':</b>
                       
                       </td><td>
                       <input type="text" id="only_domains" name="newsomatic_rules_list[only_domains][]" ';
                       if (isset($newsomatic_Main_Settings['newsapi_active']) && trim($newsomatic_Main_Settings['newsapi_active']) == 'on'){$output .= ' disabled ';}
                       $output .= 'value="' . esc_attr($only_domains) . '" placeholder="Comma separated domain list" class="cr_width_full">
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("A comma-separated string of domains (eg bbc.co.uk,techcrunch.com,engadget.com) to remove from the results.", 'newsomatic-news-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Remove Domains from Results", 'newsomatic-news-post-generator') . ':</b>
                       
                       </td><td>
                       <input type="text" id="remove_domains" name="newsomatic_rules_list[remove_domains][]" ';
                       if (isset($newsomatic_Main_Settings['newsapi_active']) && trim($newsomatic_Main_Settings['newsapi_active']) == 'on'){$output .= ' disabled ';}
                       $output .= 'value="' . esc_attr($remove_domains) . '" placeholder="Comma separated domain list" class="cr_width_full">
                           
           </div>
           </td></tr>
           <tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Do you want to remember last posted item and continue search from it the next time the importing rule runs?", 'newsomatic-news-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Cache Items For Continuous Posting (disable to get latest posts only)", 'newsomatic-news-post-generator') . ':</b>
                       
                       </td><td>
                       <input type="checkbox" id="continue_search" name="newsomatic_rules_list[continue_search][]"';
               if ($continue_search == '1') {
                   $output .= ' checked';
               }
               $output .= '>
                           
           </div>
           </td></tr>
       <tr><td colspan="2">
       <h3>' . esc_html__("Generated Post Customizations:", 'newsomatic-news-post-generator') . '</h3></td></tr>
       <tr><td class="cr_min_width_200">
       <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Set the title of the generated posts for user rules. You can use the following shortcodes:  %random_sentence%%, %%random_sentence2%%, %%item_title%%, %%author%%, %%item_description%%, %%item_content%%, %%item_original_content%%, %%item_cat%%, %%item_tags%%, %%keyword_search%%, %%item_source%%, %%item_source_id%%", 'newsomatic-news-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Generated Post Title", 'newsomatic-news-post-generator') . ':</b>&nbsp;<b><a href="https://coderevolution.ro/knowledge-base/faq/post-template-reference-advanced-usage/" target="_blank">&#9432;</a></b>
                       
                       </td><td>
                       <input type="text" name="newsomatic_rules_list[post_title][]" value="' . esc_attr(htmlspecialchars($post_title)) . '" placeholder="Please insert your desired post title. Example: %%item_title%%" class="cr_width_full">
                           
           </div>
           </td></tr><tr><td class="cr_min_width_200">
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Set the content of the generated posts for user rules. You can use the following shortcodes: %%item_read_more_button%%, %%item_media%%, %%custom_html%%, %%custom_html2%%, %%random_sentence%%, %%random_sentence2%%, %%random_image[keyword]%%, %%random_image_url[keyword]%%, %%item_date%%, %%item_media%%, %%item_title%%, %%item_description%%, %%item_content%%, %%item_original_content%%, %%item_content_plain_text%%, %%royalty_free_image_attribution%%, %%item_url%%, %%item_cat%%, %%item_tags%%, %%keyword_search%%, %%item_show_image%%, %%item_image_URL%%, %%author%%, %%author_link%%, %%item_source%%, %%item_source_id%%", 'newsomatic-news-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Generated Post Content", 'newsomatic-news-post-generator') . ':</b>&nbsp;<b><a href="https://coderevolution.ro/knowledge-base/faq/post-template-reference-advanced-usage/" target="_blank">&#9432;</a></b>
                       
                       </td><td>
                       <textarea rows="2" cols="70" name="newsomatic_rules_list[post_content][]" placeholder="Please insert your desired post content. Example:%%item_content%%" class="cr_width_full">' . htmlspecialchars($post_content) . '</textarea>
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__('Select the status that you want for the automatically generated posts to have.', 'newsomatic-news-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Generated Post Status", 'newsomatic-news-post-generator') . ':</b>   
                       </td><td>
                       <select id="submit_status" name="newsomatic_rules_list[submit_status][]" class="cr_width_70">
                             <option value="pending"';
               if($status == 'pending')
               {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Pending -> Moderate", 'newsomatic-news-post-generator') . '</option>
                             <option value="draft"';
               if($status == 'draft')
               {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Draft -> Moderate", 'newsomatic-news-post-generator') . '</option>
                             <option value="publish"';
               if($status == 'publish')
               {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Published", 'newsomatic-news-post-generator') . '</option>
                             <option value="private"';
               if($status == 'private')
               {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Private", 'newsomatic-news-post-generator') . '</option>
                             <option value="trash"';
               if($status == 'trash')
               {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Trash", 'newsomatic-news-post-generator') . '</option>
               </select>     
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__('Select the type (post/page) for your automatically generated item.', 'newsomatic-news-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Generated Post Type", 'newsomatic-news-post-generator') . ':</b>   
                       </td><td>
                       <select id="default_type" name="newsomatic_rules_list[default_type][]" class="cr_width_auto">';
       foreach ( get_post_types( '', 'names' ) as $post_type ) {
          $output .= '<option value="' . esc_attr($post_type) . '"';
          if ($def_type == $post_type) {
               $output .= ' selected';
           }
          $output .= '>' . esc_html($post_type) . '</option>';
       }
               $output .= '</select>  
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__('Select the author that you want to assign for the automatically generated posts.', 'newsomatic-news-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Generated Post Author", 'newsomatic-news-post-generator') . ':</b>   
                       </td><td>
                       <select id="post_author" name="newsomatic_rules_list[post_author][]" class="cr_width_auto cr_max_width_150">';
                       $output .= '<option value="rand"';
                       if ($post_user_name == "rand") {
                               $output .= " selected";
                           }
                       $output .= '>' . esc_html__("Random user", 'newsomatic-news-post-generator') . '</option>';
                       $output .= '<option value="feed-news"';
                       if ($post_user_name == "feed-news") {
                               $output .= " selected";
                           }
                       $output .=  '>' . esc_html__('Import crawled author', 'newsomatic-news-post-generator') . '</option>';
               $blogusers = get_users( [ 'role__in' => [ 'contributor', 'author', 'editor', 'administrator' ] ] );
               foreach ($blogusers as $user) {
                   $output .= '<option value="' . esc_html($user->ID) . '"';
                   if ($post_user_name == $user->ID) {
                       $output .= " selected";
                   }
                   $output .= '>' . esc_html($user->display_name) . '</option>';
               }
               $output .= '</select>
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Do you want to disable post excerpt generation?", 'newsomatic-news-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Disable Post Excerpt Generation:", 'newsomatic-news-post-generator') . ':</b>
                       
                       </td><td>
                       <input type="checkbox" id="disable_excerpt" name="newsomatic_rules_list[disable_excerpt][]"';
               if ($disable_excerpt == '1') {
                   $output .= ' checked';
               }
               $output .= '>   
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Do you want to to set the post published date as the date grabbed from the feed article? If you disable this feature, the date when the rule is run will be used.", 'newsomatic-news-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Get Post Publish Date From Feed", 'newsomatic-news-post-generator') . ':</b>
                       
                       </td><td>
                       <input type="checkbox" id="import_date" name="newsomatic_rules_list[import_date][]"';
           if($import_date == '1')
           {
               $output .= ' checked';
           }
           $output .= '>
                           
           </div>
           </td></tr><tr><td class="cr_min_width_200">
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__('If your template supports "Post Formats", than you can select one here. If not, leave this at it\'s default value.', 'newsomatic-news-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Generated Post Format", 'newsomatic-news-post-generator') . ':</b>   
                       </td><td>
                       <select id="post_format" name="newsomatic_rules_list[post_format][]" class="cr_width_full">
                       <option value="post-format-standard"';
               if ($post_format == 'post-format-standard') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Standard", 'newsomatic-news-post-generator') . '</option>
                       <option value="post-format-aside"';
               if ($post_format == 'post-format-aside') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Aside", 'newsomatic-news-post-generator') . '</option>
                       <option value="post-format-gallery"';
               if ($post_format == 'post-format-gallery') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Gallery", 'newsomatic-news-post-generator') . '</option>
                       <option value="post-format-link"';
               if ($post_format == 'post-format-link') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Link", 'newsomatic-news-post-generator') . '</option>
                       <option value="post-format-image"';
               if ($post_format == 'post-format-image') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Image", 'newsomatic-news-post-generator') . '</option>
                       <option value="post-format-quote"';
               if ($post_format == 'post-format-quote') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Quote", 'newsomatic-news-post-generator') . '</option>
                       <option value="post-format-status"';
               if ($post_format == 'post-format-status') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Status", 'newsomatic-news-post-generator') . '</option>
                       <option value="post-format-video"';
               if ($post_format == 'post-format-video') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Video", 'newsomatic-news-post-generator') . '</option>
                       <option value="post-format-audio"';
               if ($post_format == 'post-format-audio') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Audio", 'newsomatic-news-post-generator') . '</option>
                       <option value="post-format-chat"';
               if ($post_format == 'post-format-chat') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Chat", 'newsomatic-news-post-generator') . '</option>
                   </select>     
           </div>
           </td></tr><tr><td class="cr_min_width_200">
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Select the post category that you want for the automatically generated posts to have. To select more categories, hold down the CTRL key.", 'newsomatic-news-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Additional Post Category", 'newsomatic-news-post-generator') . ':</b>
                       
                       </td><td>
                       <select multiple class="cr_width_full" id="default_category" name="newsomatic_rules_list[default_category' . esc_html($cont) . '][]">
                       <option value="newsomatic_no_category_12345678"';
                       if(!is_array($default_category))
                       {
                           $default_category = array($default_category);
                       }
                       if(count($default_category) == 1)
                       {
                        foreach($default_category as $dc)
                        {
                            if ("newsomatic_no_category_12345678" == $dc) {
                                $output .= ' selected';
                            }
                        }
                       }
                       $output .= '>' . esc_html__("Do Not Add a Category", 'newsomatic-news-post-generator') . '</option>';
               foreach ($categories as $category) {
                   $output .= '<option value="' . esc_attr($category->term_id) . '"';
                   foreach($default_category as $dc)
                   {
                       if ($category->term_id == $dc) {
                           $output .= ' selected';
                           break;
                       }
                   }
                   
                   $output .= '>' . sanitize_text_field($category->name) . ' - ID: ' . esc_html($category->term_id) . '</option>';
               }
               $output .= '</select>     
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Do you want to automatically add post categories, from the feed items?", 'newsomatic-news-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Auto Add Categories", 'newsomatic-news-post-generator') . ':</b>
                       
                       </td><td> 
                       <select id="auto_categories" name="newsomatic_rules_list[auto_categories][]" class="cr_width_full">
                       <option value="disabled"';
               if ($auto_categories == 'disabled') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Disabled", 'newsomatic-news-post-generator') . '</option>
               <option value="title"';
               if ($auto_categories == 'title') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Title", 'newsomatic-news-post-generator') . '</option></select>              
           </div>
           </td></tr><tr><td class="cr_min_width_200">
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("This option will search the content for the keyword and if exists, it will assign the set category to the post. Example: \"sugar,diet|category_slug1,category_slug2\" without quotes - the plugin will check the content and if it contains the keyword \"sugar\" and the keyword \"diet\" it will assign the post to the category with slug=category_slug1 and also the category with slug=category_slug2.", 'newsomatic-news-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Keyword to Category (keyword|categorySlug - one per line)", 'newsomatic-news-post-generator') . ':</b>
                       
                       </td><td>
                       <textarea rows="2" cols="70" name="newsomatic_rules_list[keyword_category][]" placeholder="sugar,diet|category_slug1,category_slug2" class="cr_width_full">' . htmlspecialchars($keyword_category) . '</textarea>
                           
           </div>
           </td></tr><tr><td class="cr_min_width_200">
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("This option will search the content for the keyword and if exists, it will assign the set tag to the post. Example: \"sugar,diet|tag_slug1,tag_slug2\" without quotes - the plugin will check the content and if it contains the keyword \"sugar\" and the keyword \"diet\" it will assign the post to the tag with slug=tag_slug1 and also the tag with slug=tag_slug2.", 'newsomatic-news-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Keyword to Tag (keyword|tagSlug - one per line)", 'newsomatic-news-post-generator') . ':</b>
                       
                       </td><td>
                       <textarea rows="2" cols="70" name="newsomatic_rules_list[keyword_tag][]" placeholder="sugar,diet|tag_slug1,tag_slug2" class="cr_width_full">' . htmlspecialchars($keyword_tag) . '</textarea>
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("This feature will try to remove the WordPress\'s default post category. This may fail in case no additional categories are added, because WordPress requires at least one post category for every post.", 'newsomatic-news-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Remove WP Default Post Category", 'newsomatic-news-post-generator') . ':</b>
                       
                       </td><td>
                       <input type="checkbox" id="remove_default" name="newsomatic_rules_list[remove_default][]"';
           if($remove_default == '1')
           {
               $output .= ' checked';
           }
           $output .= '>
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Do you want to automatically add post tags from the feed items?", 'newsomatic-news-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Auto Add Tags", 'newsomatic-news-post-generator') . ':</b>
                       
                       </td><td>
                       <select id="auto_tags" name="newsomatic_rules_list[auto_tags][]" class="cr_width_full">
                       <option value="disabled"';
               if ($auto_tags == 'disabled') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Disabled", 'newsomatic-news-post-generator') . '</option>
                       <option value="title"';
               if ($auto_tags == 'title') {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html__("Title", 'newsomatic-news-post-generator') . '</option>';
               $output .= '</select>        
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Select the post tags that you want for the automatically generated posts to have.", 'newsomatic-news-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Additional Post Tags", 'newsomatic-news-post-generator') . ':</b>
                       
                       </td><td>
                       <input class="cr_width_full" type="text" name="newsomatic_rules_list[default_tags][]" value="' . esc_attr($default_tags) . '" placeholder="Please insert your additional post tags here" >
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Do you want to enable comments for the generated posts?", 'newsomatic-news-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Enable Comments For Posts", 'newsomatic-news-post-generator') . ':</b>
                       
                       </td><td>
                       <input type="checkbox" id="enable_comments" name="newsomatic_rules_list[enable_comments][]"';
               if ($enable_comments == '1') {
                   $output .= ' checked';
               }
               $output .= '>
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Do you want to enable pingbacks and trackbacks for the generated posts?", 'newsomatic-news-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Enable Pingback/Trackback", 'newsomatic-news-post-generator') . ':</b>
                       
                       </td><td>
                       <input type="checkbox" id="enable_pingback" name="newsomatic_rules_list[enable_pingback][]"';
               if ($enable_pingback == '1') {
                   $output .= ' checked';
               }
               $output .= '>
                           
           </div>
           </td></tr><tr><td class="cr_min_width_200">
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Set the custom fields that will be set for generated posts. The syntax for this field is the following: custom_field_name1 => custom_field_value1, custom_field_name2 => custom_field_value2, ... . In custom_field_valueX, you can use shortcodes, same like in post content. You can also assign the data to array custom fields, using this format: array_field[index_name1] => custom_field_value1, array_field[index_name2] => custom_field_value2. Example (without quotes): \'title_custom_field => %%item_title%%\'. You can use the following shortcodes: %%item_read_more_button%%, %%item_media%%, %%custom_html%%, %%custom_html2%%, %%random_sentence%%, %%random_sentence2%%, %%random_image[keyword]%%, %%random_image_url[keyword]%%, %%item_title%%, %%item_description%%, %%item_content%%, %%item_content_plain_text%%, %%royalty_free_image_attribution%%, %%item_url%%, %%item_cat%%, %%item_tags%%, %%keyword_search%%, %%item_show_image%%, %%item_image_URL%%, %%author%%, %%author_link%%, %%item_source%%, %%item_source_id%%", 'newsomatic-news-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Post Custom Fields", 'newsomatic-news-post-generator') . ':</b>&nbsp;<b><a href="https://coderevolution.ro/knowledge-base/faq/post-template-reference-advanced-usage/" target="_blank">&#9432;</a></b>
                       
                       </td><td>
                       <textarea rows="1" cols="70" name="newsomatic_rules_list[custom_fields][]" placeholder="Please insert your desired custom fields. Example: title_custom_field => %%item_title%%" class="cr_width_full">' . esc_textarea($custom_fields) . '</textarea>
                           
           </div>
           </td></tr><tr><td class="cr_min_width_200">
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Set the custom taxonomies that will be set for generated posts. The syntax for this field is the following: custom_taxonomy_name1 => custom_taxonomy_value1A, custom_taxonomy_value1B; custom_taxonomy_name2 => custom_taxonomy_value2A, custom_taxonomy_value2B; ... . In custom_taxonomy_valueX, you can use shortcodes. Example (without quotes): \'cats_taxonomy_field => %%item_title%%; tags_taxonomy_field => manualtax2, %%item_title%%\'. You can use the following shortcodes: %%item_read_more_button%%, %%item_media%%, %%custom_html%%, %%custom_html2%%, %%random_sentence%%, %%random_sentence2%%, %%random_image[keyword]%%, %%random_image_url[keyword]%%, %%item_title%%, %%item_description%%, %%item_content%%, %%item_content_plain_text%%, %%royalty_free_image_attribution%%, %%item_url%%, %%item_cat%%, %%item_tags%%, %%keyword_search%%, %%item_show_image%%, %%item_image_URL%%, %%author%%, %%author_link%%, %%item_source%%, %%item_source_id%%", 'newsomatic-news-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Post Custom Taxonomies", 'newsomatic-news-post-generator') . ':</b>&nbsp;<b><a href="https://coderevolution.ro/knowledge-base/faq/post-template-reference-advanced-usage/" target="_blank">&#9432;</a></b>
                       </td><td>
                           <textarea rows="1" cols="70" name="newsomatic_rules_list[custom_tax][]" placeholder="Please insert your desired custom taxonomies. Example: custom_taxonomy_name => %%item_cats%%" class="cr_width_full">' . esc_textarea($custom_tax) . '</textarea>
           </div>
           </td></tr><tr><td>
   		   <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Enter a 2 letter language code that will be assigned as the WPML/Polylang language for posts. Example: for German, input: de", 'newsomatic-news-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Assign WPML/Polylang Language to Posts", 'newsomatic-news-post-generator') . ':</b>
                       
                       </td><td>
                       <input type="text" class="cr_width_full" name="newsomatic_rules_list[wpml_lang][]" value="' . esc_attr($wpml_lang) . '" placeholder="WPML/Polylang language" class="cr_width_full">
                           
           </div>
           </td></tr><tr><td>
           <h3>' . esc_html__("Full Article Content Importing Options:", 'newsomatic-news-post-generator') . '</h3></td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Do you want to try to get full article content from the linked URL? This will replace the content of the %%item_content%% shortcode.", 'newsomatic-news-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Try to Get Full Article Content", 'newsomatic-news-post-generator') . ':</b>
                       
                       </td><td>
                       <input type="checkbox" id="full_content' . esc_html($cont) . '" name="newsomatic_rules_list[full_content][]"';
           if($full_content == '1')
           {
               $output .= ' checked';
           }
           $output .= '>               
           </div>
           </td></tr><tr><td>
           <div class="hideFull' . esc_html($cont) . '">
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Do you want to try to use PhantomJS to try to parse JavaScript from crawled pages (for pages that create dynamic content, on page load, using JavaScript)? Please note that for this to work, you must have PhantomJs installed on your server. You can configure the path to PhantomJS from your server, from plugin\'s \'Main Settings\'.", 'newsomatic-news-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Content Scraping Method To Use", 'newsomatic-news-post-generator') . ':</b><div class="cr_float_right bws_help_box bws_help_box_right dashicons cr_align_middle"><img class="cr_align_middle" src="' . plugins_url('../images/new.png', __FILE__) . '" alt="new feature"/>
                                                      <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("New feature added to this plugin: it is able to use HeadlessBrowserAPI to scrape with JavaScript rendered content any website from the internet. Also, the Tor node of the API will be able to scrape .onion sites from the Dark Net!", 'newsomatic-news-post-generator') . '</div></div>';
                       if($use_phantom == '1')
                       {
                           if($phantom === false)
                           {
                               $phantom = newsomatic_testPhantom();
                           }
                           if($phantom === 0)
                           {
                               $output .= '<br/><span class="cr_red12"><b>' . esc_html__('INFO: PhantomJS not found - please install it on your server or configure the path to it in plugin\'s \'Main Settings\'!', 'newsomatic-news-post-generator') . '</b> <a href=\'//coderevolution.ro/knowledge-base/faq/how-to-install-phantomjs/\' target=\'_blank\'>' . esc_html__('How to install PhantomJs?', 'newsomatic-news-post-generator') . '</a></span>';
                           }
                           elseif($phantom === 1)
                           {
                               $output .= '<br/><span class="cr_green12"><b>' . esc_html__('INFO: PhantomJS OK', 'newsomatic-news-post-generator') . '</b></span>';
                           }
                       }
                       $output .= '</div>
                       </td><td>
                       <div class="hideFull' . esc_html($cont) . '">
                       <select id="use_phantom' . esc_html($cont) . '" name="newsomatic_rules_list[use_phantom][]" class="cr_width_full">
                        <option value="0"';
           if ($use_phantom == '0' || $use_phantom == '') {
               $output .= ' selected';
           }
           $output .= '>' . esc_html__("WordPress (Default)", 'newsomatic-news-post-generator') . '</option>
                        <option value="1"';
           if ($use_phantom == '1') {
               $output .= ' selected';
           }
           $output .= '>' . esc_html__("Use PhantomJS", 'newsomatic-news-post-generator') . '</option>          
                        <option value="2"';
           if ($use_phantom == '2') {
               $output .= ' selected';
           }
           $output .= '>' . esc_html__("Use Puppeteer", 'newsomatic-news-post-generator') . '</option>
                          <option value="4"';
           if ($use_phantom == '4') {
               $output .= ' selected';
           }
           if (!isset($newsomatic_Main_Settings['headlessbrowserapi_key']) || trim($newsomatic_Main_Settings['headlessbrowserapi_key']) == '')
           {
               $output .= ' title="' . esc_html__("This option is disabled. To enable it, add a HeadlessBrowserAPI Key in the plugin's 'Main Settings' menu.", 'newsomatic-news-post-generator') . '" disabled';
           }
           $output .= '>' . esc_html__("Puppeteer (HeadlessBrowserAPI)", 'newsomatic-news-post-generator') . '</option>
                        <option value="5"';
           if ($use_phantom == '5') {
               $output .= ' selected';
           }
           if (!isset($newsomatic_Main_Settings['headlessbrowserapi_key']) || trim($newsomatic_Main_Settings['headlessbrowserapi_key']) == '')
           {
               $output .= ' title="' . esc_html__("This option is disabled. To enable it, add a HeadlessBrowserAPI Key in the plugin's 'Main Settings' menu.", 'newsomatic-news-post-generator') . '" disabled';
           }
           $output .= '>' . esc_html__("Tor (HeadlessBrowserAPI)", 'newsomatic-news-post-generator') . '</option>
                        <option value="6"';
           if ($use_phantom == '6') {
               $output .= ' selected';
           }
           if (!isset($newsomatic_Main_Settings['headlessbrowserapi_key']) || trim($newsomatic_Main_Settings['headlessbrowserapi_key']) == '')
           {
               $output .= ' title="' . esc_html__("This option is disabled. To enable it, add a HeadlessBrowserAPI Key in the plugin's 'Main Settings' menu.", 'newsomatic-news-post-generator') . '" disabled';
           }
           $output .= '>' . esc_html__("PhantomJS (HeadlessBrowserAPI)", 'newsomatic-news-post-generator') . '</option>
                       </select>            
           </div>
           </td></tr><tr><td>
           <div class="hideFull' . esc_html($cont) . '">
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . sprintf( wp_kses( __( 'Do you want to automatically delete generated posts after a period of time? Accepted values for this field are listed: <a href=\'%s\' target=\'_blank\'>here</a>, <a href=\'%s\' target=\'_blank\'>here</a>, <a href=\'%s\' target=\'_blank\'>here</a> and <a href=\'%s\' target=\'_blank\'>here</a>. To disable this feature, leave this field blank.', 'newsomatic-news-post-generator'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url( 'http://php.net/manual/en/datetime.formats.relative.php' ), esc_url( 'http://php.net/manual/en/datetime.formats.date.php' ), esc_url( 'http://php.net/manual/en/datetime.formats.time.php' ), esc_url( 'http://php.net/manual/en/datetime.formats.compound.php' ) ) . '
                           </div>
                       </div>
                       <b>' . esc_html__("Full Content Query Type (Optional)", 'newsomatic-news-post-generator') . ':</b>
                       </div>
                       </td><td>
                       <div class="hideFull' . esc_html($cont) . '">
                       <select id="type" name="newsomatic_rules_list[type][]" class="newsomatic_selector cr_width_full" data-source-field-id="date" data-target-field-id="expre" data-target-field-cont="' . esc_html($cont) . '">
                       <option value="auto"';
                       if($type == 'auto')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Auto Detect", 'newsomatic-news-post-generator') . '</option>
                       <option value="visual"';
                       if($type == 'visual')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Visual Selector", 'newsomatic-news-post-generator') . '</option>
                       <option value="id"';
                       if($type == 'id')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("ID", 'newsomatic-news-post-generator') . '</option>
                       <option value="class"';
                       if($type == 'class')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Class", 'newsomatic-news-post-generator') . '</option>
                       <option value="xpath"';
                       if($type == 'xpath')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("XPath", 'newsomatic-news-post-generator') . '</option>
                       <option value="regex"';
                       if($type == 'regex')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Regex", 'newsomatic-news-post-generator') . '</option>
                   </select>              
           </div>
           </td></tr><tr><td>
           <div class="hideFull' . esc_html($cont) . '">
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . sprintf( wp_kses( __( 'Input the search query for full content searching. This can be the ID or class name you want to search for, the <a href="https://regexone.com/" target="_blank">regex expression</a> you want to apply or the XPath Expression you want to query for. <a href="%s" target="_blank">More info/tutorial</a>.', 'newsomatic-news-post-generator'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url( 'https://www.w3schools.com/xml/xpath_intro.asp' ) ) . '
                           </div>
                       </div>
                       <b>' . esc_html__("HTML Search Query String (Optional)", 'newsomatic-news-post-generator') . ' <a name="help" href="admin.php?page=newsomatic_helper" target="_blank">' . esc_html__("Help!", 'newsomatic-news-post-generator') . '</a>:</b>
                       </div>
                       </td><td>
                       <div class="hideFull' . esc_html($cont) . '">
                       <input type="text" id="expre' . esc_html($cont) . '" name="newsomatic_rules_list[expre][]" value="' . htmlspecialchars($expre) . '" placeholder="Please insert your query" class="cr_width_full">
                           
           </div>
           </td></tr><tr><td>
           <div class="hideFull' . esc_html($cont) . '">
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . sprintf( wp_kses( __( 'Input the correct HTML attribute where the image src is found for lazy loaded images that are scraped from the full content. You can also add a comma separated list of multiple lazy loading tags. The attribute containing the actual image URL ex: \"data-src\", \"data-original\"', 'newsomatic-news-post-generator'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url( 'https://regexone.com/' ), esc_url( 'https://www.w3schools.com/xml/xpath_intro.asp' ) ) . '
                           </div>
                       </div>
                       <b>' . esc_html__("Lazy Loading Images HTML Tag", 'newsomatic-news-post-generator') . ':</b>
                       </div>
                       </td><td>
                       <div class="hideFull' . esc_html($cont) . '">
                       <input type="text" name="newsomatic_rules_list[lazy_tag][]" value="' . htmlspecialchars($lazy_tag) . '" placeholder="Image lazy load html tag" class="cr_width_full">
                           
           </div>
           </td></tr><tr><td class="cr_min_width_200">
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Select the cookie values you want to send with each request. The syntax for this field is the following: cookie_key1=cookie_value1; cookie_key2=cookie_value2 . To disable this feature, leave this field blank.", 'newsomatic-news-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Send Cookies With Request", 'newsomatic-news-post-generator') . ':</b>
                       
                       </td><td>
                       <textarea rows="1" cols="70" id="newsomatic_custom_cookies' . $cont . '" name="newsomatic_rules_list[custom_cookies][]" placeholder="Please insert your desired cookies. Example: cookie_key1=cookie_value1; cookie_key2=cookie_value2" class="cr_width_full">' . esc_textarea($custom_cookies) . '</textarea>
                           
           </div>
                   </td></tr><tr><td>
           <div class="hideFull' . esc_html($cont) . '">
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Select a percentage of the grabbed content that will be included in the article. This is useful when the author states that you can legally get up to 25% of the full article. To disable this feature, leave this field blank.", 'newsomatic-news-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Percentage Of The Full Content To Keep", 'newsomatic-news-post-generator') . ':</b>
                       </div>
                       </td><td>
                       <div class="hideFull' . esc_html($cont) . '">
                       <input type="number" min="1" step="1" max="100" name="newsomatic_rules_list[content_percent][]" value="' . esc_attr($content_percent) . '" placeholder="Please insert a percentage" class="cr_width_full">
                           
           </div>
           </td></tr><tr><td>
           <div class="hideFull' . esc_html($cont) . '">
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Do you want to get only one element or all elements that fit the defined rule?", 'newsomatic-news-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Get Only The First Found Element", 'newsomatic-news-post-generator') . ':</b>
                       </div>
                       </td><td>
                       <div class="hideFull' . esc_html($cont) . '">
                       <input type="checkbox" id="single" name="newsomatic_rules_list[single][]"';
           if($single == '1')
           {
               $output .= ' checked';
           }
           $output .= '>               
           </div>
           </td></tr><tr><td>
           <div class="hideFull' . esc_html($cont) . '">
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Do you want to get only the inner content of the div or the full div (with tags you searched for)?", 'newsomatic-news-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Get Only The Inner Div Content", 'newsomatic-news-post-generator') . ':</b>
                       </div>
                       </td><td>
                       <div class="hideFull' . esc_html($cont) . '">
                       <input type="checkbox" id="inner" name="newsomatic_rules_list[inner][]"';
           if($inner == '1')
           {
               $output .= ' checked';
           }
           $output .= '>               
           </div>
           </td></tr><tr><td>
           <div class="hideFull' . esc_html($cont) . '">
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Select the source page encoding", 'newsomatic-news-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Source Article Encoding", 'newsomatic-news-post-generator') . ':</b>
                       </div>
                       </td><td>
                       <div class="hideFull' . esc_html($cont) . '">
                       <select id="encoding" name="newsomatic_rules_list[encoding][]" class="cr_width_full">
                       <option value="NO_CHANGE"';
                       if($encoding == 'NO_CHANGE')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Feature Disabled", 'newsomatic-news-post-generator') . '</option>
                       <option value="AUTO"';
                       if($encoding == 'AUTO')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Auto Detect", 'newsomatic-news-post-generator') . '</option>';
       $i=0;
   	foreach($GLOBALS['encodings'] as $enc){
           $output .= '<option value="' . esc_attr($GLOBALS['encodings'][$i]) . '"'; 
           if($encoding == esc_attr($GLOBALS['encodings'][$i]))
           {
               $output .= ' selected';
           }
           $output .= '>' . esc_attr($GLOBALS['encodings'][$i]) . '</option>';
           $i++;
       }
               $output .= '</select>          
           </div>
           </td></tr><tr><td colspan="2">
       <h3>' . esc_html__("Post Content Options:", 'newsomatic-news-post-generator') . '</h3></td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Do you want to strip images from generated content?", 'newsomatic-news-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Strip Images From Content", 'newsomatic-news-post-generator') . ':</b>
                       
                       </td><td>
                       <input type="checkbox" id="strip_images" name="newsomatic_rules_list[strip_images][]"';
               if ($strip_images == '1') {
                   $output .= ' checked';
               }
               $output .= '>
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Do you want to strip article source from title?", 'newsomatic-news-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Strip Article Source From Title", 'newsomatic-news-post-generator') . ':</b>
                       
                       </td><td>
                       <input type="checkbox" id="strip_tsource" name="newsomatic_rules_list[strip_tsource][]"';
               if ($strip_tsource == '1') {
                   $output .= ' checked';
               }
               $output .= '>
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Strip HTML elements from final content that have this IDs. You can insert more IDs, separeted by comma. To disable this feature, leave this field blank.", 'newsomatic-news-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Strip HTML Elements by ID", 'newsomatic-news-post-generator') . ':</b>
                       
                       </td><td>
                       <textarea rows="1" class="cr_width_full" name="newsomatic_rules_list[strip_by_id][]" placeholder="id1, id2, id3" class="cr_width_full">' . esc_textarea($strip_by_id) . '</textarea>
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Strip HTML elements from final content that have this class. You can insert more classes, separeted by comma. To disable this feature, leave this field blank.", 'newsomatic-news-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Strip HTML Elements by Class", 'newsomatic-news-post-generator') . ':</b>
                       
                       </td><td>
                       <textarea rows="1" class="cr_width_full" name="newsomatic_rules_list[strip_by_class][]" placeholder="class1, class2, class3" class="cr_width_full">' . esc_textarea($strip_by_class) . '</textarea>
                           
           </div>
           </td></tr><tr><td>
           <div class="hideFull' . esc_html($cont) . '">
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Do you want to strip HTML from Full Content?", 'newsomatic-news-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Strip HTML From Full Content", 'newsomatic-news-post-generator') . ':</b>
                       </div>
                       </td><td>
                       <div class="hideFull' . esc_html($cont) . '">
                       <input type="checkbox" id="only_text" name="newsomatic_rules_list[only_text][]"';
           if($only_text == '1')
           {
               $output .= ' checked';
           }
           $output .= '>               
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Set a list of allowed HTML tags, if \'Strip HTML From Full Content\' checkbox is enabled. Ex: &lt;br&gt;&lt;a&gt;", 'newsomatic-news-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Alllowed HTML Tags (If Strip HTML Enabled)", 'newsomatic-news-post-generator') . ':</b>
                       
                       </td><td>
                       <textarea rows="1" class="cr_width_full" name="newsomatic_rules_list[allow_html_tags][]" placeholder="id1, id2, id3" class="cr_width_full">' . esc_textarea($allow_html_tags) . '</textarea>
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Do you want to limit the title's length to a specific word count? To disable this feature, leave this field blank.", 'newsomatic-news-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Limit Title Word Count", 'newsomatic-news-post-generator') . ':</b>
                       
                       </td><td>
                       <input type="number" min="1" step="1" id="limit_title_word_count" name="newsomatic_rules_list[limit_title_word_count][]" value="' . esc_attr($limit_title_word_count) . '" placeholder="Please insert a title limit count" class="cr_width_full">
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Do you want to limit the content\'s length to a specific word count? To disable this feature, leave this field blank.", 'newsomatic-news-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Limit Content Word Count", 'newsomatic-news-post-generator') . ':</b>
                       
                       </td><td>
                       <input type="number" min="1" step="1" id="limit_content_word_count" name="newsomatic_rules_list[limit_content_word_count][]" value="' . esc_attr($limit_content_word_count) . '" placeholder="Please insert a limit for content" class="cr_width_full">
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Run regex on post content. To disable this feature, leave this field blank.", 'newsomatic-news-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Run Regex On Content", 'newsomatic-news-post-generator') . ':</b>
                       
                       </td><td>
                       <textarea rows="1" class="cr_width_full" name="newsomatic_rules_list[strip_by_regex][]" placeholder="regex" class="cr_width_full">' . esc_textarea($strip_by_regex) . '</textarea>
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Replace the above regex matches with this regex expression. If you want to strip matched content, leave this field blank. You can add multiple Regex expressions here, each on a new line.", 'newsomatic-news-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Replace Matches From Regex (Content)", 'newsomatic-news-post-generator') . ':</b>
                       
                       </td><td>
                       <textarea rows="1" class="cr_width_full" name="newsomatic_rules_list[replace_regex][]" placeholder="regex replacement" class="cr_width_full">' . esc_textarea($replace_regex) . '</textarea>
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Run regex on post title. To disable this feature, leave this field blank. You can add multiple Regex expressions, each on a different line.", 'rss-feed-post-generator-echo') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Run Regex On Title", 'rss-feed-post-generator-echo') . ':</b>
                       
                       </td><td>
                       <textarea rows="1" class="cr_width_full" name="newsomatic_rules_list[strip_by_regex_title][]" placeholder="regex" class="cr_width_full">' . esc_textarea($strip_by_regex_title) . '</textarea>
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Replace the above regex matches with this regex expression. If you want to strip matched content, leave this field blank. You can add multiple replacement expressions, each on a different line (in this case, each will match the corresponding expression from the above Regex field.", 'rss-feed-post-generator-echo') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Replace Title Matches From Regex", 'rss-feed-post-generator-echo') . ':</b>
                       
                       </td><td>
                       <textarea rows="1" class="cr_width_full" name="newsomatic_rules_list[replace_regex_title][]" placeholder="regex replacement" class="cr_width_full">' . esc_textarea($replace_regex_title) . '</textarea>
                           
           </div>
           </td></tr><tr><td>
       <h3>' . esc_html__("Featured Image Options:", 'newsomatic-news-post-generator') . '</h3></td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Do you want to set featured image for generated post (to the first image that was found in the post)? This works only when \'Get Full Content\' is also checked.", 'newsomatic-news-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Auto Get Featured Image", 'newsomatic-news-post-generator') . ':</b>
                       
                       </td><td>
                       <input type="checkbox" id="featured_image" name="newsomatic_rules_list[featured_image][]"';
               if ($featured_image == '1') {
                   $output .= ' checked';
               }
               $output .= '>
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Do you want to skip image returned by NewsomaticAPI and use the image found in the article, instead?", 'newsomatic-news-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Skip Image Returned By NewsomaticAPI", 'newsomatic-news-post-generator') . ':</b>
                       
                       </td><td>
                       <input type="checkbox" id="skip_img" name="newsomatic_rules_list[skip_img][]"';
               if ($skip_img == '1') {
                   $output .= ' checked';
               }
               $output .= '>
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Do you want to replace the imported article's image with a royalty free image? Please note that for this feature to function you must configure the plugin (add API keys) in the plugin\'s \'Main Settings\' menu -> \'Royalty Free Featured Image Importing Options\' section.", 'newsomatic-news-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Replace Article Image With Royalty Free Image", 'newsomatic-news-post-generator') . ':</b>
                       
                       </td><td>
                       <input type="checkbox" id="royalty_free" name="newsomatic_rules_list[royalty_free][]"';
               if ($royalty_free == '1') {
                   $output .= ' checked';
               }
               $output .= '>
                           
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . sprintf( wp_kses( __( 'Select the query type you want to search for the featured image. XPath: <a href="%s" target="_blank">More info/tutorial</a>.', 'newsomatic-news-post-generator'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url( 'https://www.w3schools.com/xml/xpath_intro.asp' ) ) . '
                           </div>
                       </div>
                       <b>' . esc_html__("Featured Image Query Type", 'newsomatic-news-post-generator') . ':</b>
                       </div>
                       </td><td>
                       <div >
                       <select id="image_type' . esc_html($cont) . '" name="newsomatic_rules_list[image_type][]" class="newsomatic_selector cr_width_full" data-source-field-id="date" data-target-field-id="image_expre" data-target-field-cont="' . esc_html($cont) . '">
                       <option value="auto"';
                       if($image_type == 'auto')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Auto Detect (From HTML Meta Tags)", 'newsomatic-news-post-generator') . '</option>
                       <option value="visual"';
                       if($image_type == 'visual')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Visual Selector", 'newsomatic-news-post-generator') . '</option>
                       <option value="id"';
                       if($image_type == 'id')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("ID", 'newsomatic-news-post-generator') . '</option>
                       <option value="class"';
                       if($image_type == 'class')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Class", 'newsomatic-news-post-generator') . '</option>
                       <option value="xpath"';
                       if($image_type == 'xpath')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("XPath", 'newsomatic-news-post-generator') . '</option>
                       <option value="regex"';
                       if($image_type == 'regex')
                       {
                           $output .= ' selected';
                       }
                       $output .= '>' . esc_html__("Regex", 'newsomatic-news-post-generator') . '</option>
                   </select>              
           </div>
           </td></tr><tr><td>
           <div >
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . sprintf( wp_kses( __( 'Input the search query for featured image searching. This can be the ID or class name you want to search for, the <a href="%s" target="_blank">regex expression</a> you want to apply or the XPath Expression you want to query for. <a href="%s" target="_blank">More info/tutorial</a>. If you leave this field blank, the featured image will be automatically detected for you.', 'newsomatic-news-post-generator'), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url( 'https://regexone.com/' ), esc_url( 'https://www.w3schools.com/xml/xpath_intro.asp' ) ) . '
                           </div>
                       </div>
                       <b>' . esc_html__("Featured Image Search Query String (Optional)", 'newsomatic-news-post-generator') . ' <a name="help" href="admin.php?page=newsomatic_helper" target="_blank">' . esc_html__("Help!", 'newsomatic-news-post-generator') . '</a>:</b>
                       </div>
                       </td><td>
                       <div >
                       <input type="text" name="newsomatic_rules_list[image_expre][]" id="image_expre' . esc_html($cont). '" value="' . htmlspecialchars($image_expre) . '" placeholder="Please insert your query" class="cr_width_full">
                           
           </div>
           </td></tr><tr><td>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Insert a comma separated list of links to valid images that will be set randomly for the featured image for the posts that do not have a valid image attached or if you disabled automatical featured image generation. You can also use image numeric IDs from images found in the Media Gallery. To disable this feature, leave this field blank. You can also use the %%random_image[keyword]%% shortcode to automatically import a random image from Google Image Search with the Creative Commons filter applied. To get a related image, you can also use: %%random_image[%%item_title%%]%%", 'newsomatic-news-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Default Featured Image List", 'newsomatic-news-post-generator') . ':</b>
                       </td><td>
                       <input class="cr_width_full" type="text" name="newsomatic_rules_list[image_url][]" placeholder="Please insert the link to a valid image" value="' . esc_attr($image_url) . '"/> 
           </td></tr><tr><td>
       <h3>' . esc_html__("Translation Options:", 'newsomatic-news-post-generator') . '</h3></td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Do you want to automatically translate generated content using Google Translate? If set, this will overwrite the \'Automatically Translate Content To\' option from plugin\'s \'Main Settings\'.", 'newsomatic-news-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Automatically Translate Content To", 'newsomatic-news-post-generator') . ':</b><br/><b>' . esc_html__("Info:", 'newsomatic-news-post-generator') . '</b> ' . esc_html__("for translation, the plugin also supports WPML.", 'newsomatic-news-post-generator') . ' <b><a href="https://wpml.org/?aid=238195&affiliate_key=ix3LsFyq0xKz" target="_blank">' . esc_html__("Get WPML now!", 'newsomatic-news-post-generator') . '</a></b>
                       
                       </td><td>
                       <select class="cr_width_full" id="translate" name="newsomatic_rules_list[rule_translate][]" >';
       $i = 0;
       foreach ($GLOBALS['language_names'] as $lang) {
           $output .= '<option value="' . esc_attr($GLOBALS['language_codes'][$i]) . '"';
           if ($rule_translate == $GLOBALS['language_codes'][$i]) {
               $output .= ' selected';
           }
           $output .= '>' . esc_html($GLOBALS['language_names'][$i]) . '</option>';
           $i++;
       }
       if(isset($newsomatic_Main_Settings['deepl_auth']) && $newsomatic_Main_Settings['deepl_auth'] != '')
       {
           $i = 0;
           foreach ($GLOBALS['language_names_deepl'] as $lang) {
               $output .= '<option value="' . esc_attr($GLOBALS['language_codes_deepl'][$i]) . '"';
               if ($rule_translate == $GLOBALS['language_codes_deepl'][$i]) {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html($GLOBALS['language_names_deepl'][$i]) . '</option>';
               $i++;
           }
       }
       if(isset($newsomatic_Main_Settings['bing_auth']) && $newsomatic_Main_Settings['bing_auth'] != '')
       {
           $i = 0;
           foreach ($GLOBALS['language_names_bing'] as $lang) {
               $output .= '<option value="' . esc_attr($GLOBALS['language_codes_bing'][$i]) . '"';
               if ($rule_translate == $GLOBALS['language_codes_bing'][$i]) {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html($GLOBALS['language_names_bing'][$i]) . '</option>';
               $i++;
           }
       }
               $output .= '</select>               
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Do you want to automatically translate generated content a second time, to this final language? In some cases, this can replace word spinning of scraped content. Please note that this can increase the amount of requests made to the translation APIs. This field has no effect if you don't set also a first translation language, in the settings field from above.", 'newsomatic-news-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Do Also A Second Translation To", 'newsomatic-news-post-generator') . ':</b>
                       </div>
                       </td><td>
                       <div>
                       <select id="second_translate" name="newsomatic_rules_list[second_translate][]" class="cr_width_full">';
       $i=0;
   	foreach($GLOBALS['language_names'] as $lang){
           $output .= '<option value="' . esc_attr($GLOBALS['language_codes'][$i]) . '"'; 
           if($second_translate == esc_attr($GLOBALS['language_codes'][$i]))
           {
               $output .= ' selected';
           }
           $output .= '>' . esc_html($GLOBALS['language_names'][$i]) . '</option>';
           $i++;
       }
       if(isset($newsomatic_Main_Settings['deepl_auth']) && $newsomatic_Main_Settings['deepl_auth'] != '')
       {
           $i = 0;
           foreach ($GLOBALS['language_names_deepl'] as $lang) {
               $output .= '<option value="' . esc_attr($GLOBALS['language_codes_deepl'][$i]) . '"';
               if ($second_translate == $GLOBALS['language_codes_deepl'][$i]) {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html($GLOBALS['language_names_deepl'][$i]) . '</option>';
               $i++;
           }
       }
       if(isset($newsomatic_Main_Settings['bing_auth']) && $newsomatic_Main_Settings['bing_auth'] != '')
       {
           $i = 0;
           foreach ($GLOBALS['language_names_bing'] as $lang) {
               $output .= '<option value="' . esc_attr($GLOBALS['language_codes_bing'][$i]) . '"';
               if ($second_translate == $GLOBALS['language_codes_bing'][$i]) {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html($GLOBALS['language_names_bing'][$i]) . '</option>';
               $i++;
           }
       }
           $output .= ' </select>
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Do you want to automatically translate generated content using Google Translate? Here you can define the translation\'s source language. If set, this will overwrite the \'Automatically Translate Content To\' option from plugin\'s \'Main Settings\'.", 'newsomatic-news-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Translation Source Language", 'newsomatic-news-post-generator') . ':</b>
                       
                       </td><td>
                       <select class="cr_width_full" id="translate" name="newsomatic_rules_list[rule_translate_source][]" >';
       $i = 0;
       foreach ($GLOBALS['language_names'] as $lang) {
           $output .= '<option value="' . esc_attr($GLOBALS['language_codes'][$i]) . '"';
           if ($rule_translate_source == $GLOBALS['language_codes'][$i]) {
               $output .= ' selected';
           }
           $output .= '>' . esc_html($GLOBALS['language_names'][$i]) . '</option>';
           $i++;
       }
       if(isset($newsomatic_Main_Settings['deepl_auth']) && $newsomatic_Main_Settings['deepl_auth'] != '')
       {
           $i = 0;
           foreach ($GLOBALS['language_names_deepl'] as $lang) {
               $output .= '<option value="' . esc_attr($GLOBALS['language_codes_deepl'][$i]) . '"';
               if ($rule_translate_source == $GLOBALS['language_codes_deepl'][$i]) {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html($GLOBALS['language_names_deepl'][$i]) . '</option>';
               $i++;
           }
       }
       if(isset($newsomatic_Main_Settings['bing_auth']) && $newsomatic_Main_Settings['bing_auth'] != '')
       {
           $i = 0;
           foreach ($GLOBALS['language_names_bing'] as $lang) {
               $output .= '<option value="' . esc_attr($GLOBALS['language_codes_bing'][$i]) . '"';
               if ($rule_translate_source == $GLOBALS['language_codes_bing'][$i]) {
                   $output .= ' selected';
               }
               $output .= '>' . esc_html($GLOBALS['language_names_bing'][$i]) . '</option>';
               $i++;
           }
       }
               $output .= '</select>               
           </div>
           </td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Do you want to skip spinning of posts generated by this rule?", 'newsomatic-news-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Do Not Spin Posts Generated By This Rule", 'newsomatic-news-post-generator') . ':</b>
                       
                       </td><td>
                       <input type="checkbox" id="skip_spin_translate" name="newsomatic_rules_list[skip_spin_translate][]"';
           if($skip_spin_translate == '1')
           {
               $output .= ' checked';
           }
           $output .= '>               
           </div>
           </td></tr><tr><td>
           <h3>' . esc_html__("Miscellaneous Options:", 'newsomatic-news-post-generator') . '</h3></td></tr><tr><td>
           <div>
           <div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                                           <div class="bws_hidden_help_text cr_min_260px">' . esc_html__("Input a list of keywords that shoule be ranked for SEO, for keywords generated by this rule.They will be added 1) In the post title (create a specific rule) 2) In the META description for the post 3) In the first sentence of the first paragraph 4) In subheading with an H1 and H2 tag  5) In the Title tag and the ALT tag of the image file name of the main image.  To disable this feature, leave this field blank.", 'newsomatic-news-post-generator') . '
                           </div>
                       </div>
                       <b>' . esc_html__("Rank These Keywords For SEO in Articles", 'newsomatic-news-post-generator') . ':</b>
                       
                       </td><td>
                       <input type="text" name="newsomatic_rules_list[rank_keywords][]" value="' . esc_attr($rank_keywords) . '" placeholder="Rank keywords for SEO" class="cr_width_full">
                           
           </div>
           </td></tr></table></div> 
       </div>
       <div class="codemodalfzr-footer">
         <br/>
         <h3 class="cr_inline">Newsomatic Automatic Post Generator</h3><span id="newsomatic_ok' . esc_html($cont) . '" class="codeokfzr cr_inline">OK&nbsp;</span>
         <br/><br/>
       </div>
     </div>
   
   </div>       
                       </td>
   						<td class="cr_shrt_td2"><span class="wpnewsomatic-delete">X</span></td>
                           <td class="cr_short_td"><input type="checkbox" name="newsomatic_rules_list[active][]" class="activateDeactivateClass" value="1"';
               if (isset($active) && $active === '1') {
                   $output .= ' checked';
               }
               $output .= '/>
                           <input type="hidden" name="newsomatic_rules_list[last_run][]" value="' . esc_attr($last_run) . '"/></td>
                           <td class="cr_shrt_td2"><div class="bws_help_box bws_help_box_right dashicons dashicons-editor-help cr_align_middle">
                           <div class="bws_hidden_help_text cr_min_260px">' . sprintf( wp_kses( __( 'Shortcode for this rule<br/>(to cross-post from this plugin in other plugins):', 'newsomatic-news-post-generator'), array(  'br' => array( ) ) ) ) . '<br/><b>%%newsomatic_0_' . esc_html($cont) . '%%</b><br/>' . esc_html__('Posts Generated:', 'newsomatic-news-post-generator') . ' ' . esc_html($generated_posts) . '<br/>';
               if ($generated_posts != 0) {
                   $output .= '<a href="' . get_admin_url() . 'edit.php?coderevolution_post_source=Newsomatic_0_' . esc_html($cont) . '&post_type=' . esc_html($def_type) . '" target="_blank">' . esc_html__('View Generated Posts', 'newsomatic-news-post-generator') . '</a><br/>';
               }
               $output .= esc_html__('Last Run: ', 'newsomatic-news-post-generator');
               if ($last_run == '1988-01-27 00:00:00') {
                   $output .= 'Never';
               } else {
                   $output .= $last_run;
               }
               $output .= '<br/>' . esc_html__('Next Run: ', 'newsomatic-news-post-generator');
               if($unlocker == '1')
               {
                   $nextrun = newsomatic_add_minute($last_run, $schedule);
               }
               else
               {
                   $nextrun = newsomatic_add_hour($last_run, $schedule);
               }
               $now     = newsomatic_get_date_now();
               if ( defined( 'DISABLE_WP_CRON' ) && DISABLE_WP_CRON ) {
                   $output .= esc_html__('WP-CRON Disabled. Rules will not automatically run!', 'newsomatic-news-post-generator');
               }
               else
               {
                   if (isset($active) && $active === '1') {
                       if($unlocker == '1')
                       {
                           $newsomatic_hour_diff = (int)newsomatic_minute_diff($now, $nextrun);
                       }
                       else
                       {
                           $newsomatic_hour_diff = (int)newsomatic_hour_diff($now, $nextrun);
                       }
                       if ($newsomatic_hour_diff >= 0) {
                           $append = 'Now.';
                           $cron   = _get_cron_array();
                           if ($cron != FALSE) {
                               $date_format = _x('Y-m-d H:i:s', 'Date Time Format1', 'newsomatic-news-post-generator');
                               foreach ($cron as $timestamp => $cronhooks) {
                                   foreach ((array) $cronhooks as $hook => $events) {
                                       if ($hook == 'newsomaticaction') {
                                           foreach ((array) $events as $key => $event) {
                                               $append = date_i18n($date_format, $timestamp);
                                           }
                                       }
                                   }
                               }
                           }
                           $output .= $append;
                       } else {
                           $output .= $nextrun;
                       }
                   } else {
                       $output .= esc_html__('Rule Disabled', 'newsomatic-news-post-generator');
                   }
               }
               $output .= '<br/>' . esc_html__('Local Time: ', 'newsomatic-news-post-generator') . $now;
               $output .= '</div>
                       </div></td>
                           <td class="cr_center">
                           <div>
                           <img id="run_img' . esc_html($cont) . '" src="' . plugin_dir_url(dirname(__FILE__)) . 'images/running.gif' . '" alt="Running" class="cr_status_icon';
               if (!empty($running)) {           
                   if (!in_array(array($cont => '0'), $running)) {
                       $output .= ' cr_hidden';
                   }
                   else
                   {
                       $f = fopen(get_temp_dir() . 'newsomatic_0_' . $cont, 'w');
                       if($f !== false)
                       {
                           if (!flock($f, LOCK_EX | LOCK_NB)) {
                           }
                           else
                           {
                               flock($f, LOCK_UN);
                               $output .= ' cr_hidden';
                               if (($xxkey = array_search(array($cont => '0'), $running)) !== false) {
                                   unset($running[$xxkey]);
                                   update_option('newsomatic_running_list', $running);
                               }
                           }
                       }
                   }
               } else {
                   $output .= ' cr_hidden';
               }
               $output .= '" title="status">
                           <div class="codemainfzr">
                           <select id="actions" class="actions" name="actions" onchange="actionsChangedManual(' . esc_html($cont) . ', this.value, 0);" onfocus="this.selectedIndex = 0;">
                               <option value="select" disabled selected>' . esc_html__("Select an Action", 'newsomatic-news-post-generator') . '</option>
                               <option value="run">' . esc_html__("Run This Rule Now", 'newsomatic-news-post-generator') . '</option>
                               <option value="trash">' . esc_html__("Move All Posts To Trash", 'newsomatic-news-post-generator') . '</option>
                               <option value="duplicate">' . esc_html__("Duplicate This Rule", 'newsomatic-news-post-generator') . '</option>
                               <option value="delete">' . esc_html__("Permanently Delete All Posts", 'newsomatic-news-post-generator') . '</option>
                           </select>
                           </div>
                           </div>
                           </td>
   					</tr>	
   					';
               $cont = $cont + 1;
           }
       }
       return $output;
   }
   ?>